package com.mini.mshow.model.type;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.mini.framework.core.exception.standard.UnsupportedException;
import com.mini.trace.model.type.ActionBehaviourType;


/**
 * 互动类型
 * 
 * @author jayheo
 *
 */
public enum SubjectInteractType {

	/**
	 * 浏览
	 */
	browse("浏览"),

	/**
	 * 分享
	 */
	share("分享"),
	
	/**
	 * 收藏
	 */
	collect("收藏"),
	/**
	 * 赞
	 */
	praise("点赞"),
	
	/**
	 * 如果某人复制了别人的某个主题，
	 * 那么这个关系就是copyfrom
	 */
	copyFrom("复制源端"),
	

	/**
	 * 如果某人复制了别人的某个主题得到一个主题
	 * 那么某人与得到的主题是复制结果的关系
	 */
	copyAs("复制结果"),

	;
	private String title;

	SubjectInteractType(String title) {
		this.title = title;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}
	
	/**
	 * 可以取消的关系
	 * @return
	 */
	public static List<SubjectInteractType> canCancelTypes(){
		return Stream.of(collect,praise).collect(Collectors.toList());
	}
	
	/**
	 * 看是不是可以取消的关系
	 * @param cancel
	 * @return
	 */
	public boolean canCancel(){
		return canCancelTypes().contains(this);
	}
	
	public ActionBehaviourType tryMapBehaviour(){
		try {
			return mapBehaviour();
		} catch (UnsupportedException e) {
			//ignore e
			return null;
		}
	}
	
	public ActionBehaviourType mapBehaviour(){
		switch (this) {
		case browse:
			return ActionBehaviourType.browse;
		case collect:
			return ActionBehaviourType.collect;
		case praise:
			return ActionBehaviourType.praise;
		case share:
			return ActionBehaviourType.share;
		case copyAs:
		case copyFrom:
		default:
			throw new UnsupportedException("找不到与:[%s]匹配的行为", this);
		}
	}

}
