/*
 * Decompiled with CFR 0.152.
 */
package com.mini.mshow.model.dbto.site;

import com.mini.framework.core.exception.standard.UnsupportedException;
import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.framework.model.role.write.Insertable;
import com.mini.framework.model.role.write.Updatable;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.mshow.model.dbto.able.SupportBrowseStatistics;
import com.mini.mshow.model.dbto.able.SupportCollectStatistics;
import com.mini.mshow.model.dbto.able.SupportPraiseStatistics;
import com.mini.mshow.model.dbto.able.SupportShareStatistics;
import com.mini.mshow.model.type.SubjectInteractType;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SubjectActivityStatisticsDbto
extends DbtoIntEntity
implements SupportBrowseStatistics,
SupportShareStatistics,
SupportPraiseStatistics,
SupportCollectStatistics {
    private static final long serialVersionUID = 6149160031081726843L;
    @Insertable(require="\u6d3b\u52a8id")
    @Updatable(forbid="\u6d3b\u52a8id")
    private Integer activityId;
    @Insertable(require="\u6d3b\u52a8\u6807\u9898", minLength=2, maxLength=30)
    @Updatable(suffice="\u6d3b\u52a8\u6807\u9898", minLength=2, maxLength=30)
    private String title;
    @Insertable(require="\u6d3b\u52a8\u4f5c\u8005")
    @Updatable(forbid="\u6d3b\u52a8\u4f5c\u8005")
    private Integer authorId;
    @Insertable(require="\u88ab\u6536\u85cf\u6570")
    @Updatable(suffice="\u88ab\u6536\u85cf\u6570")
    private Integer collectedNum;
    @Insertable(require="\u603b\u88ab\u6536\u85cf\u6570")
    @Updatable(suffice="\u603b\u88ab\u6536\u85cf\u6570")
    private Integer allCollectedNum;
    @Insertable(require="\u88ab\u53d6\u6d88\u6536\u85cf\u6570")
    @Updatable(suffice="\u88ab\u53d6\u6d88\u6536\u85cf\u6570")
    private Integer cancelCollectedNum;
    @Insertable(require="\u88ab\u8d5e\u6570")
    @Updatable(suffice="\u88ab\u8d5e\u6570")
    private Integer praisedNum;
    @Insertable(require="\u603b\u88ab\u8d5e\u6570")
    @Updatable(suffice="\u603b\u88ab\u8d5e\u6570")
    private Integer allPraisedNum;
    @Insertable(require="\u88ab\u53d6\u6d88\u8d5e\u6570")
    @Updatable(suffice="\u88ab\u53d6\u6d88\u8d5e\u6570")
    private Integer cancelPraisedNum;
    @Insertable(require="\u88ab\u6d4f\u89c8\u6570")
    @Updatable(suffice="\u88ab\u6d4f\u89c8\u6570")
    private Integer browsedNum;
    @Insertable(require="\u88ab\u5206\u4eab\u6570")
    @Updatable(suffice="\u88ab\u5206\u4eab\u6570")
    private Integer sharedNum;

    public Integer getActivityId() {
        return this.activityId;
    }

    public void setActivityId(Integer activityId) {
        this.activityId = activityId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getAuthorId() {
        return this.authorId;
    }

    public void setAuthorId(Integer authorId) {
        this.authorId = authorId;
    }

    @Override
    public Integer getCollectedNum() {
        return this.collectedNum;
    }

    @Override
    public void setCollectedNum(Integer collectedNum) {
        this.collectedNum = collectedNum;
    }

    @Override
    public Integer getCancelCollectedNum() {
        return this.cancelCollectedNum;
    }

    @Override
    public void setCancelCollectedNum(Integer cancelCollectedNum) {
        this.cancelCollectedNum = cancelCollectedNum;
    }

    @Override
    public Integer getPraisedNum() {
        return this.praisedNum;
    }

    @Override
    public void setPraisedNum(Integer praisedNum) {
        this.praisedNum = praisedNum;
    }

    @Override
    public Integer getCancelPraisedNum() {
        return this.cancelPraisedNum;
    }

    @Override
    public void setCancelPraisedNum(Integer cancelPraisedNum) {
        this.cancelPraisedNum = cancelPraisedNum;
    }

    @Override
    public Integer getBrowsedNum() {
        return this.browsedNum;
    }

    @Override
    public void setBrowsedNum(Integer browsedNum) {
        this.browsedNum = browsedNum;
    }

    @Override
    public Integer getAllCollectedNum() {
        return this.allCollectedNum;
    }

    @Override
    public void setAllCollectedNum(Integer allCollectedNum) {
        this.allCollectedNum = allCollectedNum;
    }

    @Override
    public Integer getAllPraisedNum() {
        return this.allPraisedNum;
    }

    @Override
    public void setAllPraisedNum(Integer allPraisedNum) {
        this.allPraisedNum = allPraisedNum;
    }

    @Override
    public Integer getSharedNum() {
        return this.sharedNum;
    }

    @Override
    public void setSharedNum(Integer sharedNum) {
        this.sharedNum = sharedNum;
    }

    public SubjectActivityStatisticsDbto create(boolean cencer, SubjectInteractType interactType) {
        SubjectActivityStatisticsDbto at = new SubjectActivityStatisticsDbto();
        int plus = cencer ? -1 : 1;
        switch (interactType) {
            case browse: {
                at.setBrowsedNum(1);
                break;
            }
            case collect: {
                at.setCollectedNum(plus);
                break;
            }
            case praise: {
                at.setPraisedNum(plus);
                break;
            }
        }
        return at;
    }

    public SubjectActivityStatisticsDbto(Consumer<SubjectActivityStatisticsDbto> function) {
        function.accept(this);
    }

    public SubjectActivityStatisticsDbto() {
    }

    public static SubjectActivityStatisticsDbto createInit(Integer activityId, String title, Integer authorId) {
        SubjectActivityStatisticsDbto init = new SubjectActivityStatisticsDbto();
        init.activityId = activityId;
        init.title = title;
        init.authorId = authorId;
        return init.initNum();
    }

    public SubjectActivityStatisticsDbto initNum() {
        this.collectedNum = 0;
        this.allCollectedNum = 0;
        this.cancelCollectedNum = 0;
        this.praisedNum = 0;
        this.allPraisedNum = 0;
        this.cancelPraisedNum = 0;
        this.browsedNum = 0;
        this.sharedNum = 0;
        return this;
    }

    public int showStatisticsNum(SubjectInteractType interactType) {
        switch (interactType) {
            case browse: {
                return this.browsedNum;
            }
            case share: {
                return this.sharedNum;
            }
            case collect: {
                return this.collectedNum;
            }
            case praise: {
                return this.praisedNum;
            }
        }
        throw new UnsupportedException("\u6d3b\u52a8\u6682\u65f6\u4e0d\u662f\u652f\u6301%s\u7684\u589e\u91cf", new Object[]{interactType});
    }

    public static boolean supportStatistics(SubjectInteractType interactType) {
        AssertUtil.assertMethodRequire((Object)((Object)interactType), (String)"interactType");
        return Stream.of(SubjectInteractType.browse, SubjectInteractType.share, SubjectInteractType.collect, SubjectInteractType.praise).collect(Collectors.toSet()).contains((Object)interactType);
    }

    public static SubjectActivityStatisticsDbto createAtomByInteract(SubjectInteractType interactType, boolean cancel) {
        AssertUtil.assertMethodRequire((Object)((Object)interactType), (String)"interactType");
        SubjectActivityStatisticsDbto atom = new SubjectActivityStatisticsDbto();
        switch (interactType) {
            case browse: {
                atom.atomIncreaseBrowse();
                break;
            }
            case share: {
                atom.atomIncreaseShare();
                break;
            }
            case collect: {
                atom.atomSwitchCollect(cancel);
                break;
            }
            case praise: {
                atom.atomSwitchPraise(cancel);
                break;
            }
            default: {
                throw new UnsupportedException("\u6d3b\u52a8\u6682\u65f6\u4e0d\u662f\u652f\u6301%s\u7684\u589e\u91cf", new Object[]{interactType});
            }
        }
        return atom;
    }
}

