package com.mini.mshow.model.dto.multi;

import java.lang.reflect.Type;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;

public class ContentDeserializer implements JsonDeserializer<Content> {

	@Override
	public Content deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context)
			throws JsonParseException {
		JsonObject jsonObject = json.getAsJsonObject();
		JsonElement bizJsonElement = jsonObject.get(MultiContentType.jsonKey());
		String typeStr = bizJsonElement.getAsString();
		MultiContentType type = MultiContentType.parse(typeStr);
		Class<? extends Content> clazz = type.getType();
		return context.deserialize(json, clazz);
	}
}