package com.mini.mshow.model.dbto.site;

import com.mini.framework.model.able.UseStatusOptional;
import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.mshow.model.dbto.able.HavePcard;
import com.mini.mshow.model.type.PcardAttentType;

/**
 * 名片对于于不同维度打分分数越高越好
 * @author jayheo
 *
 */
public class PcardAttentScoreDbto extends DbtoIntEntity implements HavePcard,UseStatusOptional{

	/**
	 * 
	 */
	private static final long serialVersionUID = 8662779720865452594L;

	/**
	 * 名片的id
	 */
	private Integer pcardId;
	
	/**
	 * 关注的点类型
	 */
	private PcardAttentType attent;
	
	/**
	 * 打分
	 * 通过各个 纬度来打分，用来控制顺序
	 */
	private Double score;
	
	/**
	 * 是不是使用
	 * TODO 这个还没有实际应用到功能中
	 */
	private Boolean useStatus;
	
	/**
	 * 使用的顺序
	 * TODO 这个还没有实际应用到功能中
	 */
	private Double useSorter;

	public Integer getPcardId() {
		return pcardId;
	}

	public void setPcardId(Integer pcardId) {
		this.pcardId = pcardId;
	}

	public PcardAttentType getAttent() {
		return attent;
	}

	public void setAttent(PcardAttentType attent) {
		this.attent = attent;
	}

	public Double getScore() {
		return score;
	}

	public void setScore(Double score) {
		this.score = score;
	}
	
	public Boolean getUseStatus() {
		return useStatus;
	}

	public void setUseStatus(Boolean useStatus) {
		this.useStatus = useStatus;
	}

	public Double getUseSorter() {
		return useSorter;
	}

	public void setUseSorter(Double useSorter) {
		this.useSorter = useSorter;
	}

	@Override
	public Integer showPcardId() {
		return pcardId;
	}

	@Override
	public boolean showUseStatus() {
		return countUseStatus(useStatus);
	}

	@Override
	public double showUseSorter() {
		return countUseSorter(useSorter);
	}
	
}
