package com.mini.mshow.model.type;

import com.mini.framework.util.asserts.TypeSwitchAssert;

/**
 * 接收到名片的状态
 * @author jayheo
 *
 */
public enum ReceiveStatusType implements TypeSwitchAssert{

/**
	 * 接受
	 */
	accept(new String[]{}),
	
	/**
	 * 拒绝 
	 */
	refuse(new String[]{}),
	/**
	 * 忽略
	 */
	skip(new String[]{"accept","refuse"}),
	
	/**
	 * 等待中
	 */
	waiting(new String[]{"accept","refuse","skip"});
	
	private String[] nexts;

	private ReceiveStatusType(String[] nexts) {
		this.nexts = nexts;
	}

	@Override
	public String[] showNexts() {
		return nexts;
	}

	@Override
	public String showSelfName() {
		return name();
	}
}
