package com.mini.mshow.model.dbto.site;

import java.util.Date;

import com.mini.framework.core.exception.standard.UnsupportedException;
import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.framework.model.role.write.Insertable;
import com.mini.framework.model.role.write.Updatable;
import com.mini.mshow.model.dbto.able.HavePcard;
import com.mini.mshow.model.type.ReceiveStatusType;

/**
 * 名片发送与接收的记录
 * 为什么要使用int而不是long型，考虑到如果数据量上20亿早已改变存储方式了
 * @author jayheo
 *
 */
public class PcardSendReceiveStatusDbto extends DbtoIntEntity implements HavePcard{

	/**
	 * 
	 */
	private static final long serialVersionUID = 464993082287278130L;
	
	/**
	 * 发送人的用户id
	 */
	@Insertable(require="发送者id")
	@Updatable(forbid="发送者id")
	private Integer senderUserId;
	
	/**
	 * 被发送的名片的id
	 */
	@Insertable(require="被发送的名片的id")
	@Updatable(forbid="被发送的名片的id")
	private Integer sendedPcardId;
	
	/**
	 * 接收着的用户id
	 */
	@Insertable(require="接收着的用户id")
	@Updatable(forbid="接收着的用户id")
	private Integer receiveUserId;
	
	
	/**
	 * 接受到名片的状态
	 */
	@Insertable(require="名片接受的状态")
	@Updatable(suffice="名片接受的状态")
	private ReceiveStatusType status;
	
	/**
	 * 达到接收状态的时间
	 */
	@Updatable(suffice="达到接收状态的时间")
	private Date acceptDate;
	
	/**
	 *  达到拒绝 状态的时间
	 */
	@Updatable(suffice="达到拒绝状态的时间")
	private Date refuseDate;
	/**
	 * 达到忽略 状态的时间
	 */
	@Updatable(suffice="达到忽略状态的时间")
	private Date skipDate;
	
	/**
	 * 达到等待状态的时间
	 */
	@Updatable(suffice="达到等待状态的时间")
	private Date sendedDate;
	
	/**
	 * 发送方忘记这条记录
	 */
	@Insertable(require="发送方忘记这条记录")
	@Updatable(suffice="发送方忘记这条记录")
	private Boolean senderForget;

	public Integer getSenderUserId() {
		return senderUserId;
	}

	public void setSenderUserId(Integer senderUserId) {
		this.senderUserId = senderUserId;
	}

	public Integer getSendedPcardId() {
		return sendedPcardId;
	}

	public void setSendedPcardId(Integer sendedPcardId) {
		this.sendedPcardId = sendedPcardId;
	}

	public Integer getReceiveUserId() {
		return receiveUserId;
	}

	public void setReceiveUserId(Integer receiveUserId) {
		this.receiveUserId = receiveUserId;
	}

	public ReceiveStatusType getStatus() {
		return status;
	}

	public void setStatus(ReceiveStatusType status) {
		this.status = status;
	}

	public Date getAcceptDate() {
		return acceptDate;
	}

	public void setAcceptDate(Date acceptDate) {
		this.acceptDate = acceptDate;
	}

	public Date getRefuseDate() {
		return refuseDate;
	}

	public void setRefuseDate(Date refuseDate) {
		this.refuseDate = refuseDate;
	}

	public Date getSkipDate() {
		return skipDate;
	}

	public void setSkipDate(Date skipDate) {
		this.skipDate = skipDate;
	}

	public Date getSendedDate() {
		return sendedDate;
	}

	public void setSendedDate(Date sendedDate) {
		this.sendedDate = sendedDate;
	}
	public Boolean getSenderForget() {
		return senderForget;
	}

	public void setSenderForget(Boolean senderForget) {
		this.senderForget = senderForget;
	}

	/**
	 * 根据状态设置状态的时间
	 * @param status
	 * @return
	 */
	public static PcardSendReceiveStatusDbto createSwitchStatus(ReceiveStatusType status){
		PcardSendReceiveStatusDbto record = new PcardSendReceiveStatusDbto();
		record.setStatus(status);
		switch (status) {
		case accept:
			record.setAcceptDate(new Date());
			break;
		case refuse:
			record.setRefuseDate(new Date());
			break;
		case skip:
			record.setSkipDate(new Date());
			break;
		case waiting:
			record.setSendedDate(new Date());
			break;
		default:
			throw new UnsupportedException("不支持的状态设置", status);
		}
		return record;
	}

	@Override
	public Integer showPcardId() {
		return sendedPcardId;
	}
	
}
