package com.mini.mshow.model.dbto.site;

import com.mini.framework.model.dbto.style1.DbtoLongEntity;
import com.mini.framework.model.role.write.Insertable;
import com.mini.framework.model.role.write.Updatable;
import com.mini.mshow.model.type.SubjectInteractType;
import com.mini.mshow.model.type.SubjectType;

/**
 * 主题与用户的互动
 * 用户对象类型对象id互动类型
 * 
 * @author jayheo
 *
 */
public class SubjectUserInteractDbto extends DbtoLongEntity {

	/**
	 * 
	 */
	private static final long serialVersionUID = -297209592342483844L;

	@Insertable(require="互动执行者")
	@Updatable(forbid= "互动执行者")
	private Integer actionUserId;

	@Insertable(require="互动主题id")
	@Updatable(forbid= "互动主题id")
	private Integer subjectId;
	
	/**
	 * 冗余这个主的作者的id
	 */
	@Insertable(require="主题作者id")
	@Updatable(forbid= "主题作者id")
	private Integer subjectAuthorId;

	@Insertable(require="互动主题类型")
	@Updatable(forbid= "互动主题类型")
	private SubjectType subjectType;
	
	@Insertable(require="互动类型")
	private SubjectInteractType interactType;
	
	/**
	 * 相关的主题id
	 * 比如说我复制了主题7得到主题9
	 * 这个事件有两条数据，
	 * 1 copyFrom 这里是9 
	 * 2 copyAs 这里是7
	 */
	private Integer relatedSubjectId;
	

	/**
	 * 相关的主题的作者，这是冗余数据
	 */
	private Integer relatedSubjectAuthorId;

	public Integer getActionUserId() {
		return actionUserId;
	}

	public void setActionUserId(Integer actionUserId) {
		this.actionUserId = actionUserId;
	}

	public Integer getSubjectId() {
		return subjectId;
	}

	public void setSubjectId(Integer subjectId) {
		this.subjectId = subjectId;
	}

	public SubjectType getSubjectType() {
		return subjectType;
	}

	public void setSubjectType(SubjectType subjectType) {
		this.subjectType = subjectType;
	}

	public SubjectInteractType getInteractType() {
		return interactType;
	}

	public void setInteractType(SubjectInteractType interactType) {
		this.interactType = interactType;
	}
	

	public Integer getSubjectAuthorId() {
		return subjectAuthorId;
	}

	public void setSubjectAuthorId(Integer subjectAuthorId) {
		this.subjectAuthorId = subjectAuthorId;
	}

	public Integer getRelatedSubjectId() {
		return relatedSubjectId;
	}

	public void setRelatedSubjectId(Integer relatedSubjectId) {
		this.relatedSubjectId = relatedSubjectId;
	}

	public Integer getRelatedSubjectAuthorId() {
		return relatedSubjectAuthorId;
	}

	public void setRelatedSubjectAuthorId(Integer relatedSubjectAuthorId) {
		this.relatedSubjectAuthorId = relatedSubjectAuthorId;
	}
	

	public SubjectUserInteractDbto() {
		super();
	}

	/**
	 * 添加一个用户与主题相关需要的基本数据
	 * @param actionUserId
	 * @param subjectId
	 * @param subjectAuthorId
	 * @param subjectType
	 * @param interactType
	 */
	public SubjectUserInteractDbto(Integer actionUserId, Integer subjectId,int subjectAuthorId, SubjectType subjectType,
			SubjectInteractType interactType) {
		super();
		this.actionUserId = actionUserId;
		this.subjectId = subjectId;
		this.subjectAuthorId = subjectAuthorId;
		this.subjectType = subjectType;
		this.interactType = interactType;
	}
	
	/**
	 * 添加一个用户与主题相关需要的基本数据
	 * 再加上相关的主题以前相关主题的作者
	 * @param actionUserId
	 * @param subjectId
	 * @param subjectAuthorId
	 * @param subjectType
	 * @param interactType
	 * @param relatedSubjectId
	 * @param relatedSubjectAuthorId
	 */
	public SubjectUserInteractDbto(Integer actionUserId, Integer subjectId, Integer subjectAuthorId,
			SubjectType subjectType, SubjectInteractType interactType, Integer relatedSubjectId,
			Integer relatedSubjectAuthorId) {
		super();
		this.actionUserId = actionUserId;
		this.subjectId = subjectId;
		this.subjectAuthorId = subjectAuthorId;
		this.subjectType = subjectType;
		this.interactType = interactType;
		this.relatedSubjectId = relatedSubjectId;
		this.relatedSubjectAuthorId = relatedSubjectAuthorId;
	}

	public static SubjectUserInteractDbto interactSpecial(int actionUserId,int specialId,int specialAuthorId,SubjectInteractType interactType){
		return new SubjectUserInteractDbto(actionUserId, specialId,specialAuthorId, SubjectType.special,interactType);
	}
	
	public static SubjectUserInteractDbto interactActivity(int actionUserId,int activityId,int activityAuthorId,SubjectInteractType interactType){
		return new SubjectUserInteractDbto(actionUserId, activityId,activityAuthorId, SubjectType.activity, interactType);
	}

	public static SubjectUserInteractDbto interactAlbum(int actionUserId, int albumId,int albumAuthorId,SubjectInteractType interactType) {
		return new SubjectUserInteractDbto(actionUserId, albumId,albumAuthorId, SubjectType.album, interactType);
	}

	public static SubjectUserInteractDbto interactAlbumPhoto(int actionUserId, int photoId,int photoAuthorId,SubjectInteractType interactType) {
		return new SubjectUserInteractDbto(actionUserId, photoId, photoAuthorId,SubjectType.photo, interactType);
	}

	

}
