package com.mini.mshow.model.dbto.able;

import java.util.function.Function;

import com.mini.framework.core.status.Status.Busy;
import com.mini.framework.util.asserts.AssertUtil;

/**
 * 多媒体数据从专业题中拿
 * @author jayheo
 *
 */
public interface MultiContentFromSpecial {

	public void setMultiContent(String multiContent);
	
	public Integer getFromSpecialId();

	public boolean fromSpecial();
	
	
	/**
	 * 确认MultiContent内容
	 * @param specialMultiContentFinder
	 */
	default public void sureMultiContent(Function<Integer, String> specialMultiContentFinder){
		if(fromSpecial()){
			AssertUtil.assertNotFatal(getFromSpecialId()!=null, Busy.dataUnConfigSite, "多媒体页面数据不完整");
			String multiContent = specialMultiContentFinder.apply(getFromSpecialId());
			this.setMultiContent(multiContent);
		}
	}
}
