package com.mini.mshow.model.dbto.site;

import java.util.Date;
import java.util.function.Function;
import java.util.function.Supplier;

import org.apache.commons.lang3.StringUtils;

import com.mini.framework.core.status.Status.Busy;
import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.framework.model.role.write.Insertable;
import com.mini.framework.model.role.write.Updatable;
import com.mini.framework.model.role.write.Writable;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.date.DateUtil;
import com.mini.framework.util.date.TimeSectionType;
import com.mini.framework.util.string.PinyinUtil;
import com.mini.framework.util.string.RegexUtil;
import com.mini.mshow.model.dbto.able.HaveOwner;
import com.mini.mshow.model.dbto.able.HavePcard;
import com.mini.mshow.model.dbto.able.HavePhone;
import com.mini.mshow.model.dto.multi.MultiFactory;

/**
 * 媒体秀个人名片
 * @author jayheo
 *
 */
public class MshowPcardDbto extends DbtoIntEntity implements HavePhone,HavePcard,HaveOwner{

	private static final String createAccessRole = "createAccess";
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 2288174186928897732L;

	/**
	 * 拥有者不可以修改的
	 */
	@Writable(insert={
		@Insertable(require="拥有者id"),
		@Insertable(require="拥有者id",role=createAccessRole)
	})
	@Updatable(forbid="拥有者id")
	private Integer ownerId;

	/**
	 * 复杂的内容
	 */
	@Insertable(require="多媒体内容")
	@Updatable(suffice="多媒体内容")
	private String multiContent;

	/**
	 * 名字
	 */
	@Insertable(require="个人名片名字",minLength=2,maxLength=15)
	@Updatable(suffice="个人名片名字",minLength=2,maxLength=15)
	private String name;
	
	/**
	 * 名片头像，这个数据是冗余的不一定和
	 */
	@Insertable(require="名片头像",minLength=6)
	@Updatable(suffice="名片头像",minLength=6)
	private String headUrl;


	/**
	 * 名字的全拼，用于排序
	 */
	@Insertable(require="名字的全拼",maxLength=30)
	@Updatable(suffice="名字的全拼",maxLength=30)
	private String fullSpell;
	
	/**
	 * 个性签名
	 */
	@Updatable(suffice="个性签名")
	private String sign;
	
	
	/**
	 * 电子邮箱
	 */
	@Updatable(suffice="电子邮箱")
	private String email;
	
	/**
	 * 电话
	 */
	@Insertable(require="个人名片电话",minLength=11,maxLength=11)
	@Updatable(suffice="个人名片电话",minLength=11,maxLength=11)
	private String phone;

	/**
	 * 地址
	 */
	@Updatable(suffice="个人名片地址",minLength=4)
	private String address;
	

	/**
	 * 地址GPS
	 * 用户短横线隔开
	 * 经度-纬度
	 */
	@Updatable(suffice="地址GPS")
	private String addressGps;

	/**
	 * 微信号
	 */
	@Insertable(require="个人名片微信号",minLength=3,maxLength=35)
	@Updatable(suffice="个人名片微信号",minLength=3,maxLength=35)
	private String weixinNo;

	/**
	 * 公司
	 */
	@Updatable(suffice="个人名片公司",minLength=2,maxLength=20)
	private String company;

	/**
	 * 职位
	 */
	@Updatable(suffice="个人名片职位",minLength=2,maxLength=10)
	private String position;

	/**
	 * 过期的日期
	 * TODO 程序会做一个定时任务，在扫个数据，对于快过期的的在做相应的处理
	 */
	@Writable(insert={
			@Insertable(require="个人名片过期的日期"),
			@Insertable(require="个人名片过期的日期",role=createAccessRole),
	})
	@Updatable(suffice="个人名片过期的日期")
	private Date expireDate;
	
	@Updatable(suffice="简历概述",minLength=8,maxLength=2000)
	private String briefTitle;
	
	/**
	 * MshowPcardStyleDbto
	 * 风格样式
	 */
	@Updatable(suffice="名片风格id")
	private Integer styleId;
	
	
	/**
	 * 手机隐私保护
	 */
	@Updatable(suffice="手机隐私保护")
	@Insertable(require="手机隐私保护")
	private Boolean privatePhone;
	
	/**
	 * 公司职位隐私保护
	 */
	@Updatable(suffice="公司职位隐私保护")
	@Insertable(require="公司职位隐私保护")
	private Boolean privateWork;

	/**
	 * 微信号隐私保护
	 */
	@Updatable(suffice="微信号隐私保护")
	@Insertable(require="微信号隐私保护")
	private Boolean privateWeixin;
	
	
	public MshowPcardDbto(){
		
	}
	
	public String getSign() {
		return sign;
	}

	public void setSign(String sign) {
		this.sign = sign;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public Integer getOwnerId() {
		return ownerId;
	}

	public void setOwnerId(Integer ownerId) {
		this.ownerId = ownerId;
	}

	public String getMultiContent() {
		return multiContent;
	}

	public void setMultiContent(String multiContent) {
		this.multiContent = multiContent;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getFullSpell() {
		return fullSpell;
	}

	public void setFullSpell(String fullSpell) {
		this.fullSpell = fullSpell;
	}

	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getAddressGps() {
		return addressGps;
	}

	public void setAddressGps(String addressGps) {
		this.addressGps = addressGps;
	}

	public String getWeixinNo() {
		return weixinNo;
	}

	public void setWeixinNo(String weixinNo) {
		this.weixinNo = weixinNo;
	}

	public String getCompany() {
		return company;
	}

	public void setCompany(String company) {
		this.company = company;
	}

	public String getPosition() {
		return position;
	}

	public void setPosition(String position) {
		this.position = position;
	}

	public Date getExpireDate() {
		return expireDate;
	}

	public void setExpireDate(Date expireDate) {
		this.expireDate = expireDate;
	}


	public String getHeadUrl() {
		return headUrl;
	}

	public void setHeadUrl(String headUrl) {
		this.headUrl = headUrl;
	}
	
	public String getBriefTitle() {
		return briefTitle;
	}

	public void setBriefTitle(String briefTitle) {
		this.briefTitle = briefTitle;
	}
	
	public Integer getStyleId() {
		return styleId;
	}

	public void setStyleId(Integer styleId) {
		this.styleId = styleId;
	}
	

	public Boolean getPrivatePhone() {
		return privatePhone;
	}

	public void setPrivatePhone(Boolean privatePhone) {
		this.privatePhone = privatePhone;
	}

	public Boolean getPrivateWork() {
		return privateWork;
	}

	public void setPrivateWork(Boolean privateWork) {
		this.privateWork = privateWork;
	}

	public Boolean getPrivateWeixin() {
		return privateWeixin;
	}

	public void setPrivateWeixin(Boolean privateWeixin) {
		this.privateWeixin = privateWeixin;
	}
	
	public boolean ifPrivatePhone(){
		return privatePhone!=null && privatePhone;
	}

	public boolean ifPrivateWeixin(){
		return privateWeixin!=null && privateWeixin;
	}
	
	/**
	 * 显示出来，显示前问一下隐私保护
	 * @param showField
	 * @param ifPrivate
	 * @param privateShow
	 * @param noShow
	 * @return
	 */
	public <T> T showAskPrivate(Function<MshowPcardDbto, T> showField,Function<MshowPcardDbto, Boolean> ifPrivate,T privateShow,T noShow ){
		if(ifPrivate.apply(this)){
			return privateShow;
		}else if(showField.apply(this)==null){
			return noShow;
		}else{
			return showField.apply(this);
		}
	}
	
	
	
	public boolean ifPrivateWork(){
		return privateWork!=null && privateWork;
	}
	
	/**
	 * 得到headUrl 的oss路径
	 * @return
	 */
	public String getHeadUrlOssPath(){
		if(headUrl!=null){
			return RegexUtil.getUrlNamespace(headUrl).substring(1);
		}
		return null;
	}

	/**
	 * 针对目标要不要隐私
	 * @param targetUserId
	 * @return
	 */
	public MshowPcardDbto applyPrivateFor(Integer targetUserId){
		if(!showOwnerId().equals(targetUserId)){
			applyPrivate();
		}
		return this;
	}
	
	/**
	 * 应用隐私功能
	 * 一般在别人查看自己的名片的时候要应用此功能。
	 * @return 
	 */
	public MshowPcardDbto applyPrivate(){
		if(ifPrivatePhone()){
			this.phone = null;
		}
		if(ifPrivateWeixin()){
			this.weixinNo = null;
		}
		if(ifPrivateWork()){
			this.company = null;
			this.position = null;
		}
		return this;
	}
	
	/**
	 * 显示实际使用的背景
	 * @param defaultSupplier
	 * @return
	 */
	public int showUseStyleId(Supplier<Integer> defaultSupplier){
		Integer id = styleId;
		if(id==null){
			id = defaultSupplier.get();
		}
		AssertUtil.assertNotFatal(id!=null, Busy.dataUnConfigSite, "没有找到默认的名片样式");
		return id;
	}

	@Override
	public Integer showPcardId() {
		return getId();
	}

	@Override
	public String showPhone() {
		return phone;
	}

	@Override
	public Integer showOwnerId() {
		return ownerId;
	}
	
	public void valiCreateAccess(){
		valiInsert(createAccessRole);
	}
	
	/**
	 * 计算续租后能到的日期
	 * @param timeSectionType
	 * @param amount
	 */
	public Date reletExpireDate(TimeSectionType timeSectionType, Integer amount){
		return reletExpireDate(expireDate, timeSectionType, amount);
	}
	
	/**
	 * 计算续租后能到的日期
	 * @param oldExireDate
	 * @param peer
	 * @param amount
	 * @return
	 */
	public static Date reletExpireDate(Date oldExireDate,TimeSectionType peer,int amount){
		Date now = new Date();
		Date newExpireDate = oldExireDate==null ||oldExireDate.before(now)?now:oldExireDate;
		newExpireDate = DateUtil.addTimeUnit(peer, newExpireDate, amount);
		newExpireDate = DateUtil.getCleanedTauchDateUnit(TimeSectionType.day, newExpireDate);
		return newExpireDate;
	}
	
	/**
	 * 尝试把名字弄成拼音
	 */
	public void trySetPinyin(){
		if(name!=null){
			fullSpell = PinyinUtil.toFirstPinyin(name);
			fullSpell = StringUtils.substring(fullSpell, 0, 30);
		}
	}
	
	/**
	 * 把MultiContent忽略掉
	 * @return 
	 */
	public MshowPcardDbto skipMulti(){
		this.setMultiContent(null);
		return this;
	}
	
	public MshowPcardDbto createBasicContent(){
		multiContent = MultiFactory.getBasic().toJson();
		return this;
	}
	
	public void dfd(){
		showAskPrivate(MshowPcardDbto::getPhone, MshowPcardDbto::ifPrivatePhone, "电话隐私保护", "无电话号码");
	}
	
	
	public static enum FieldShow{

		/**
		 * 名字
		 */
		name(MshowPcardDbto::getName),
		
		/**
		 * 手机号
		 */
		phone((pcard)->{
			return pcard.showAskPrivate(MshowPcardDbto::getPhone, MshowPcardDbto::ifPrivatePhone, "电话隐私保护", "无电话号码");
		}),
		
		/**
		 * 职位名
		 */
		position((pcard)->{
			return pcard.showAskPrivate(MshowPcardDbto::getPosition, MshowPcardDbto::ifPrivateWork, "职位隐私保护", "暂无职位");
		}),
		
		/**
		 * 公司名
		 */
		company((pcard)->{
			return pcard.showAskPrivate(MshowPcardDbto::getCompany, MshowPcardDbto::ifPrivateWork, "公司隐私保护", "暂无公司名称");
		}),
		/**
		 * headUrl 的oss路径
		 */
		headUrlOssPath(MshowPcardDbto::getHeadUrlOssPath);;
		
		private Function<MshowPcardDbto, Object> fieldSupplier;

		public Function<MshowPcardDbto, Object> getFieldSupplier() {
			return fieldSupplier;
		}

		private FieldShow(Function<MshowPcardDbto, Object> fieldSupplier) {
			this.fieldSupplier = fieldSupplier;
		}
		
		public Object getField(MshowPcardDbto pcard){
			AssertUtil.assertMethodRequire(pcard, "pcard");
			return fieldSupplier.apply(pcard);
		}
		
		public static Object getField(String fieldType,MshowPcardDbto pcard){
			AssertUtil.assertMethodRequire(fieldType, "fieldType");
			return FieldShow.valueOf(fieldType).getField(pcard);
		}
	}
	
	

	// 对于名片是有没有点亮什么卡通过另外一个数据来记录

}
