package com.mini.mshow.model.dbto.site;

import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.framework.model.role.write.Insertable;
import com.mini.framework.model.role.write.Updatable;
import com.mini.mshow.model.dbto.able.MultiContentFromSpecial;
import com.mini.mshow.model.type.PagePostionType;

/**
 * 页面上的图文视音
 * @author jayheo
 *
 */
public class PagePwvvDbto extends DbtoIntEntity implements MultiContentFromSpecial{

	/**
	 * 
	 */
	private static final long serialVersionUID = -8836939215548169754L;

	/**
	 * 内容
	 */
	@Updatable(suffice="页面图文视音内容")
	private String multiContent;

	/**
	 * 位置
	 */
	@Insertable(require="页面图文视音位置")
	@Updatable(suffice="页面图文视音位置")
	private PagePostionType postion;
	
	@Updatable(suffice="关键值")
	private String key;
	
	
	@Updatable(suffice="名字")
	private String name;

	/**
	 * 方案的索引 同一个东西允许有多个方案，这里是方案的索引
	 */
	@Insertable(require="页面图文视音索引")
	@Updatable(suffice="页面图文视音索引")
	private Integer schemeIndex;
	
	/**
	 * 权重
	 */
	@Insertable(require="页面图文视音权重")
	@Updatable(suffice="页面图文视音权重")
	private Integer weight;
	
	@Updatable(suffice="使用范围")
	private String scope;
	
	/**
	 * 为了方便，如果multiContent没有的话可以从Special找到数据
	 * 对应的专题id
	 */
	@Updatable(suffice="对应的专题id")
	private Integer fromSpecialId;
	

	/**
	 * 是否从专题中拿数据
	 */
	@Updatable(suffice="是否从专题中拿数据")
	private Boolean fromSpecial;

	public String getMultiContent() {
		return multiContent;
	}

	public void setMultiContent(String multiContent) {
		this.multiContent = multiContent;
	}

	public PagePostionType getPostion() {
		return postion;
	}

	public void setPostion(PagePostionType postion) {
		this.postion = postion;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Integer getSchemeIndex() {
		return schemeIndex;
	}

	public void setSchemeIndex(Integer schemeIndex) {
		this.schemeIndex = schemeIndex;
	}

	public Integer getWeight() {
		return weight;
	}

	public void setWeight(Integer weight) {
		this.weight = weight;
	}

	public String getScope() {
		return scope;
	}

	public void setScope(String scope) {
		this.scope = scope;
	}

	public Boolean getFromSpecial() {
		return fromSpecial;
	}

	public void setFromSpecial(Boolean fromSpecial) {
		this.fromSpecial = fromSpecial;
	}

	public Integer getFromSpecialId() {
		return fromSpecialId;
	}

	public void setFromSpecialId(Integer fromSpecialId) {
		this.fromSpecialId = fromSpecialId;
	}
	
	@Override
	public boolean fromSpecial() {
		return fromSpecial !=null && fromSpecial;
	}
	
}
