package com.mini.mshow.model.dbto.site;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;











import org.apache.commons.lang3.StringUtils;

import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.framework.model.role.write.Insertable;
import com.mini.framework.model.role.write.Updatable;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.mshow.model.dbto.able.HaveAuthor;
import com.mini.mshow.model.dbto.able.IsOneSubject;
import com.mini.mshow.model.dto.multi.Content;
import com.mini.mshow.model.dto.multi.MultiContent;
import com.mini.mshow.model.dto.multi.MultiContentType;
import com.mini.mshow.model.dto.multi.PhotoContent;
import com.mini.mshow.model.dto.multi.VideoContent;
import com.mini.mshow.model.dto.multi.WordsContent;
import com.mini.mshow.model.type.SubjectType;

/**
 * 相册/专题/活动的总览概要信息
 * 每个相册/专题/活动都会展示自己的概要
 * 这个数据会从multiContent中计算出来
 * @author jayheo
 *
 */
public class SubjectOverviewDbto extends DbtoIntEntity implements HaveAuthor{

	/**
	 * 
	 */
	private static final long serialVersionUID = 8942830178819272948L;

	
	public static SubjectOverviewDbto findOverview(MultiContent multiContent,int maxWords){
		AssertUtil.assertMethodRequire(multiContent, "multiContent");
		List<Content> contents = multiContent.getContents();
		SubjectOverviewDbto subjectOverviewDbto = new SubjectOverviewDbto();
		if(contents!=null){
			contents.stream().sorted().forEach(content->{
				MultiContentType type = content.getType();
				switch (type) {
				case photo :
					PhotoContent photo = content.takeContent();
					subjectOverviewDbto.onPhotoFound(photo.getResourse());
					break;
				case words :
					if(subjectOverviewDbto.subTitle==null){
						WordsContent words = content.takeContent();
						subjectOverviewDbto.subTitle = StringUtils.abbreviate(words.getWords(),maxWords);
					}
					break;
				case video :
					if(subjectOverviewDbto.videoCoverUrl==null){
						VideoContent video = content.takeContent();
						subjectOverviewDbto.videoCoverUrl =video.getCover();
						subjectOverviewDbto.videoUrl =video.getSourse();
					}
					break;

				default:
					//其他情况暂时不处理
					break;
				}
			}
			);
		}
		return subjectOverviewDbto;
	}
	
	/**
	 * 当发现个图片的时候
	 * @param photo
	 * @return
	 */
	private int onPhotoFound(String photo) {
		AssertUtil.assertMethodRequire(photo, "photo");
		if(firstPhoto==null){
			firstPhoto = photo;
			return 1;
		}else if(secondPhoto==null){
			secondPhoto = photo;
			return 2;
		}else if(thirdlyPhoto==null){
			thirdlyPhoto = photo;
			return 3;
		}else{
			return 0;
		}
	}
	
	/**
	 * 填充重要的图片
	 * @param photos
	 * @return
	 */
	public SubjectOverviewDbto fillImportantPhoto(String... photos){
		for (String photo : photos) {
			onPhotoFound(photo);
		}
		return this;
	}


	public SubjectOverviewDbto fillSubjectField(IsOneSubject subject){
		setSubjectAuthorId(subject.showAuthorId());
		setSubjectId(subject.showSubjectId());
		setSubjectType(subject.showSubectType());
		return this;
	}
	
	
	private Map<String, String> fieldDesces = createFieldDesces();
	
	
	
	
	@Insertable(require="互动主题id")
	@Updatable(forbid= "互动主题id")
	private Integer subjectId;

	@Insertable(require="互动主题类型")
	@Updatable(forbid= "互动主题类型")
	private SubjectType subjectType;
	
	/**
	 * 冗余这个主的作者的id
	 */
	@Insertable(require="主题作者id")
	@Updatable(forbid= "主题作者id")
	private Integer subjectAuthorId;

	
	
	/**
	 * 标题
	 */
	@Insertable(require ="标题")
	@Updatable(suffice ="标题")
	private String title;
	
	/**
	 * 子标题
	 */
	@Updatable(suffice ="子标题",maxLength=200)
	private String subTitle;
	
	/**
	 * 删除的状态默认是没有删除false
	 */
	@Insertable(require ="删除的状态")
	@Updatable(suffice ="删除的状态")
	private Boolean delStatus;
	
	/**
	 * 第一张图片
	 */
	@Updatable(suffice ="第一张图片")
	private String firstPhoto;
	/**
	 * 第二张图片
	 */
	@Updatable(suffice ="第二张图片")
	private String secondPhoto;
	/**
	 * 第三张图片
	 */
	@Updatable(suffice ="第三张图片")
	private String thirdlyPhoto;
	
	/**
	 * 视频的地址
	 */
	@Updatable(suffice ="视频地址")
	private String videoUrl;
	
	/**
	 * 视频的封面地址
	 */
	@Updatable(suffice ="视频封面地址")
	private String videoCoverUrl;

	public String getTitle() {
		return title;
	}

	private Map<String, String> createFieldDesces() {
		Map<String, String> desces = new LinkedHashMap<>();
		desces.put("说明1，显示标题和一照片","判断firstPhoto存在且secondPhoto不存在时使用");
		desces.put("说明2，显示标题和二照片","判断firstPhoto存在且secondPhoto存在且thirdlyPhoto不存在时使用");
		desces.put("说明3，显示标题和三照片","判断firstPhoto存在且secondPhoto存在且thirdlyPhoto存在时使用");
		desces.put("说明4，显示标题和子标题","判断存在且subTitle存在时使用");
		desces.put("说明5，显示标题和视频","判断videoUrl存在且coverUrl存在时使用");
		desces.put("说明6，其它情况","异常一定要把这个打印出来，暂时显示标题");
		desces.put("说明7，是否存在被删除了?","delStatus表示是不是删除true表示已删除，false表示存在没有删除，如果被删除了");
		return desces ;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getSubTitle() {
		return subTitle;
	}

	public void setSubTitle(String subTitle) {
		this.subTitle = subTitle;
	}

	public String getFirstPhoto() {
		return firstPhoto;
	}

	public void setFirstPhoto(String firstPhoto) {
		this.firstPhoto = firstPhoto;
	}

	public String getSecondPhoto() {
		return secondPhoto;
	}

	public void setSecondPhoto(String secondPhoto) {
		this.secondPhoto = secondPhoto;
	}

	public String getThirdlyPhoto() {
		return thirdlyPhoto;
	}

	public void setThirdlyPhoto(String thirdlyPhoto) {
		this.thirdlyPhoto = thirdlyPhoto;
	}

	public String getVideoUrl() {
		return videoUrl;
	}

	public void setVideoUrl(String videoUrl) {
		this.videoUrl = videoUrl;
	}
	

	public Integer getSubjectId() {
		return subjectId;
	}


	public void setSubjectId(Integer subjectId) {
		this.subjectId = subjectId;
	}


	public SubjectType getSubjectType() {
		return subjectType;
	}


	public void setSubjectType(SubjectType subjectType) {
		this.subjectType = subjectType;
	}


	public Integer getSubjectAuthorId() {
		return subjectAuthorId;
	}


	public void setSubjectAuthorId(Integer subjectAuthorId) {
		this.subjectAuthorId = subjectAuthorId;
	}


	public String getVideoCoverUrl() {
		return videoCoverUrl;
	}


	public void setVideoCoverUrl(String videoCoverUrl) {
		this.videoCoverUrl = videoCoverUrl;
	}


	public void setFieldDesces(Map<String, String> fieldDesces) {
		this.fieldDesces = fieldDesces;
	}


	public Map<String, String> getFieldDesces() {
		return fieldDesces;
	}

	public Boolean getDelStatus() {
		return delStatus;
	}

	public void setDelStatus(Boolean delStatus) {
		this.delStatus = delStatus;
	}


	@Override
	public Integer showAuthorId() {
		return subjectAuthorId;
	}
	
}
