package com.mini.mshow.model.dbto.site;

import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.framework.model.role.write.Insertable;
import com.mini.framework.model.role.write.Updatable;


/**
 * 用户线下订单的使用剩余量
 * @author jayheo
 *
 */
public class AccessStaffOfflineOrderSurplusDbto extends DbtoIntEntity{

	/**
	 * 
	 */
	private static final long serialVersionUID = 7682487352683905209L;
	
	@Insertable(require="员工id")
	@Updatable(forbid="员工id")
	private Integer staffId;
	
	
	@Insertable(require="员工用户id")
	@Updatable(forbid="员工用户id")
	private Integer staffUserId;
	
	/**
	 * 剩余可以使用的钱，单位是分
	 */
	@Insertable(require="剩余可以使用的钱")
	@Updatable(suffice="剩余可以使用的钱")
	private Integer surplusMoney;
	
	/**
	 * 当前可使用状态
	 * 用这个状态来限制员工，防止滥使用
	 */
	@Insertable(require="当前可使用状态")
	@Updatable(suffice="当前可使用状态")
	private Boolean useStatus;

	
	public Integer getStaffId() {
		return staffId;
	}

	public void setStaffId(Integer staffId) {
		this.staffId = staffId;
	}

	public Integer getSurplusMoney() {
		return surplusMoney;
	}

	public void setSurplusMoney(Integer surplusMoney) {
		this.surplusMoney = surplusMoney;
	}

	public Boolean getUseStatus() {
		return useStatus;
	}

	public void setUseStatus(Boolean useStatus) {
		this.useStatus = useStatus;
	}
	
	public Integer getStaffUserId() {
		return staffUserId;
	}

	public void setStaffUserId(Integer staffUserId) {
		this.staffUserId = staffUserId;
	}

	public boolean showUseStatus() {
		return useStatus !=null && useStatus;
	}
	
	
	
}
