package com.mini.mshow.model.dbto.site;

import java.util.Optional;

import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.framework.model.role.write.Insertable;
import com.mini.framework.model.role.write.Updatable;
import com.mini.mshow.model.dbto.able.HaveAuthor;
import com.mini.mshow.model.dbto.able.HaveSpecial;
import com.mini.mshow.model.dbto.able.IsOneSubject;
import com.mini.mshow.model.dto.multi.MultiFactory;
import com.mini.mshow.model.type.SubjectType;


public class SubjectSpecialDbto extends DbtoIntEntity implements HaveAuthor ,HaveSpecial,IsOneSubject{

	/**
	 * 
	 */
	private static final long serialVersionUID = 6149160031081726843L;

	
	
	
	public SubjectOverviewDbto tryFindOverview(){
		boolean right = MultiFactory.validate(multiContent);
		SubjectOverviewDbto overview = null;
		if(right){
			overview = SubjectOverviewDbto.findOverview(MultiFactory.fromJson(multiContent),200);
		}else{
			overview = new SubjectOverviewDbto();
		}
		overview.onImportantPhotoFound(Optional.ofNullable(cover));
		overview.setTitle(title);
		return overview.fillSubjectField(this);
	}
	
	public void fillFixField(SubjectOverviewDbto overview){
		if(overview!=null){
			overview.setSubjectAuthorId(authorId);
			overview.setSubjectId(getId());
			overview.setSubjectType(SubjectType.special);
		}
	}
	
	
	/**
	 * 专题标题
	 */
	@Insertable(require="专题标题",minLength=2,maxLength=50)
	@Updatable(suffice="专题标题",minLength=2,maxLength=50)
	private String title;
	
	/**
	 * 复杂的内容
	 */
	@Insertable(require="多媒体内容",minLength=2)
	@Updatable(suffice="多媒体内容",minLength=2)
	private String multiContent;
	
	/**
	 * 作者的用户 id
	 */
	@Insertable(require="专题作者")
	@Updatable(forbid="专题作者")
	private Integer authorId;
	
	/**
	 * 原创的key，标记这个东西是谁
	 * 这个东西用于在复制的时候记录是谁原创的
	 */
	@Insertable(require="原始作者")
	@Updatable(forbid="原始作者")
	private Integer originalAuthorId;
	
	@Updatable(suffice="封面")
	private String cover;
	
	/**
	 * 如果当前是置顶状态显示最后一次置顶的时间
	 * 最后一次置顶的时间
	 */
	@Updatable(suffice="置顶")
	private Boolean topShow;
	
	@Updatable(suffice="置顶排序器")
	private Double topShowSorter;
	

	/**
	 * 排序依据
	 */
	@Updatable(suffice="排序依据")
	private Double sorter;


	public String getTitle() {
		return title;
	}


	public void setTitle(String title) {
		this.title = title;
	}


	public String getMultiContent() {
		return multiContent;
	}


	public void setMultiContent(String multiContent) {
		this.multiContent = multiContent;
	}


	public Integer getAuthorId() {
		return authorId;
	}


	public void setAuthorId(Integer authorId) {
		this.authorId = authorId;
	}


	public Integer getOriginalAuthorId() {
		return originalAuthorId;
	}


	public void setOriginalAuthorId(Integer originalAuthorId) {
		this.originalAuthorId = originalAuthorId;
	}
	

	public String getCover() {
		return cover;
	}

	public void setCover(String cover) {
		this.cover = cover;
	}
	
	public Boolean getTopShow() {
		return topShow;
	}

	public void setTopShow(Boolean topShow) {
		this.topShow = topShow;
	}

	public Double getTopShowSorter() {
		return topShowSorter;
	}

	public void setTopShowSorter(Double topShowSorter) {
		this.topShowSorter = topShowSorter;
	}

	public Double getSorter() {
		return sorter;
	}

	public void setSorter(Double sorter) {
		this.sorter = sorter;
	}

	@Override
	public Integer showAuthorId() {
		return authorId;
	}


	@Override
	public Integer showSpecialId() {
		return getId();
	}


	@Override
	public SubjectType showSubectType() {
		return SubjectType.special;
	}


	@Override
	public Integer showSubjectId() {
		return getId();
	}
	
	/**
	 * 把MultiContent忽略掉
	 * @return 
	 */
	public SubjectSpecialDbto skipMulti(){
		this.setMultiContent(null);
		return this;
	}

	public boolean ifTopShowParams() {
		return topShow!=null || topShowSorter!=null;
	}
	
	
}
