package com.mini.mshow.model.dbto.site;

import java.util.Date;
import java.util.Optional;

import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.framework.model.role.write.Insertable;
import com.mini.framework.model.role.write.Updatable;
import com.mini.mshow.model.dbto.able.HaveActivity;
import com.mini.mshow.model.dbto.able.HaveAuthor;
import com.mini.mshow.model.dbto.able.IsOneSubject;
import com.mini.mshow.model.dto.multi.MultiFactory;
import com.mini.mshow.model.type.SubjectType;

public class SubjectActivityDbto extends DbtoIntEntity implements HaveActivity,HaveAuthor,IsOneSubject{

	/**
	 * 
	 */
	private static final long serialVersionUID = 6149160031081726843L;

	
	public SubjectOverviewDbto tryFindOverview(){
		boolean right = MultiFactory.validate(multiContent);
		SubjectOverviewDbto overview = null;
		if(right){
			overview = SubjectOverviewDbto.findOverview(MultiFactory.fromJson(multiContent),200);
		}else{
			overview = new SubjectOverviewDbto();
		}
		overview.onImportantPhotoFound(Optional.ofNullable(cover));
		overview.setTitle(title);
		overview.setSubTitle(subTitle);
		// TODO 如果活动有封面应该弄去上
		return overview.fillSubjectField(this);
	}
	
	/**
	 * 标题
	 */
	@Insertable(require="活动标题",minLength=2,maxLength=30)
	@Updatable(suffice="活动标题",minLength=2,maxLength=30)
	private String title;

	/**
	 * 活动子标题
	 */
	@Insertable(require="活动子标题",minLength=10,maxLength=200)
	@Updatable(suffice="活动子标题",minLength=10,maxLength=200)
	private String subTitle;

	/**
	 * 复杂的内容
	 */
	@Insertable(require="活动多媒体")
	@Updatable(suffice="活动多媒体")
	private String multiContent;
	
	/**
	 * 作者的用户 id
	 */
	@Insertable(require="活动作者")
	@Updatable(forbid="活动作者")
	private Integer authorId;
	
	
	/**
	 * 原创的key，标记这个东西是谁
	 * 这个东西用于在复制的时候记录是谁原创的
	 */
	@Insertable(require="原始作者")
	@Updatable(forbid="原始作者")
	private Integer originalAuthorId;
	
	
	/**
	 * 开始时间
	 */
	@Insertable(require="开始时间")
	@Updatable(suffice="开始时间")
	private Date beginDate;
	

	/**
	 * 结束时间
	 */
	@Insertable(require="结束时间")
	@Updatable(suffice="结束时间")
	private Date endDate;
	
	
	/**
	 * 地址名字
	 */
	@Insertable(require="地址名字",minLength=2)
	@Updatable(suffice="地址名字",minLength=2)
	private String addressName;
	

	/**
	 * 地址GPS
	 * 用户短横线隔开
	 * 经度-纬度
	 */
	@Updatable(suffice="地址GPS")
	private String addressGps;
	
	
	/**
	 * 主办方
	 */
	@Insertable(require="主办方",minLength=2)
	@Updatable(suffice="主办方",minLength=2)
	private String presider;
	
	
	@Updatable(suffice="封面")
	private String cover;
	
	/**
	 * 如果当前是置顶状态显示最后一次置顶的时间
	 * 最后一次置顶的时间
	 */
	@Updatable(suffice="置顶")
	private Boolean topShow;
	
	@Updatable(suffice="置顶排序器")
	private Double topShowSorter;
	

	/**
	 * 排序依据
	 */
	@Updatable(suffice="排序依据")
	private Double sorter;
	
	
	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getMultiContent() {
		return multiContent;
	}

	public void setMultiContent(String multiContent) {
		this.multiContent = multiContent;
	}

	public String getSubTitle() {
		return subTitle;
	}

	public void setSubTitle(String subTitle) {
		this.subTitle = subTitle;
	}

	public Integer getAuthorId() {
		return authorId;
	}

	public void setAuthorId(Integer authorId) {
		this.authorId = authorId;
	}


	public Integer getOriginalAuthorId() {
		return originalAuthorId;
	}


	public void setOriginalAuthorId(Integer originalAuthorId) {
		this.originalAuthorId = originalAuthorId;
	}
	
	public Date getBeginDate() {
		return beginDate;
	}

	public void setBeginDate(Date beginDate) {
		this.beginDate = beginDate;
	}

	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public String getAddressName() {
		return addressName;
	}

	public void setAddressName(String addressName) {
		this.addressName = addressName;
	}

	public String getAddressGps() {
		return addressGps;
	}

	public void setAddressGps(String addressGps) {
		this.addressGps = addressGps;
	}

	public String getPresider() {
		return presider;
	}

	public void setPresider(String presider) {
		this.presider = presider;
	}
	
	public String getCover() {
		return cover;
	}

	public void setCover(String cover) {
		this.cover = cover;
	}
	
	public Boolean getTopShow() {
		return topShow;
	}

	public void setTopShow(Boolean topShow) {
		this.topShow = topShow;
	}

	public Double getTopShowSorter() {
		return topShowSorter;
	}

	public void setTopShowSorter(Double topShowSorter) {
		this.topShowSorter = topShowSorter;
	}

	public Double getSorter() {
		return sorter;
	}

	public void setSorter(Double sorter) {
		this.sorter = sorter;
	}

	@Override
	public Integer showActivityId() {
		return getId();
	}

	@Override
	public Integer showAuthorId() {
		return authorId;
	}

	@Override
	public SubjectType showSubectType() {
		return SubjectType.activity;
	}

	@Override
	public Integer showSubjectId() {
		return getId();
	}
	
	
	/**
	 * 把MultiContent忽略掉
	 * @return 
	 */
	public SubjectActivityDbto skipMulti(){
		this.setMultiContent(null);
		return this;
	}
	
	public SubjectActivityDbto copy(){
		SubjectActivityDbto copyActivity = new SubjectActivityDbto();
		copyActivity .setAuthorId(authorId);
		copyActivity.setOriginalAuthorId(originalAuthorId);
		copyActivity.setTitle(this.getTitle());
		copyActivity.setSubTitle(this.getSubTitle());
		copyActivity.setMultiContent(this.getMultiContent());
		copyActivity.setBeginDate(this.getBeginDate());
		copyActivity.setEndDate(this.getEndDate());
		copyActivity.setPresider(this.getPresider());
		copyActivity.setAddressName(this.getAddressName());
		copyActivity.setAddressGps(this.getAddressGps());
		copyActivity.setCover(this.getCover());
		return copyActivity;
	}

	
	/**
	 * 判断有没有topShow的参数
	 * @return
	 */
	public boolean ifTopShowParams(){
		return topShow!=null || topShowSorter!=null;
	}
}
