package com.mini.mshow.model.dbto.site;

import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.framework.model.role.write.Insertable;
import com.mini.framework.model.role.write.Updatable;
import com.mini.mshow.model.type.ResourseType;

/**
 * 资源
 * @author jayheo
 *
 */
public class ResourseDbto extends DbtoIntEntity{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1147819667900895123L;
	
	
	/**
	 * 资源的地址
	 */
	@Insertable(require="资源地址")
	@Updatable(suffice="资源地址")
	private String resUrl;
	
	/**
	 * 原文件的地址有的资源不是上传，还是去另一个地方读取的，这就是读取的地址
	 */
	@Updatable(forbid="原文件的地址")
	private String originUrl;
	
	/**
	 * 资源类型
	 */
	@Insertable(require="资源类型")
	@Updatable(suffice="资源类型")
	private ResourseType type;
	
	/**
	 * 资源大小，单位字节
	 */
	@Updatable(suffice="资源大小(字节)")
	private int size;
	
	/**
	 * 文件类型
	 */
	@Updatable(suffice="资源文件类型")
	private String fileType;
	/**
	 * 文件后缀，不包含那个 .
	 */
	@Updatable(suffice="资源文件后缀")
	private String suffix;
	
	/**
	 * 资源属于谁
	 */
	@Insertable(require="资源归属")
	@Updatable(forbid="资源归属")
	private Integer ownerId;
	
	/**
	 * 要不要放到历史的资源中
	 */
	@Insertable(require="资源放入历史")
	@Updatable(suffice="资源放入历史")
	private Boolean history;
	
	/**
	 * 视频的封面
	 * 如果资源是视频的话可以拿到视频的封面
	 */
	//@Insertable(suffice="视频的封面")
	@Updatable(suffice="视频的封面")
	private String videoCover;
	

	@Updatable(suffice="图片的高")
	private Integer photoHeight;
	

	@Updatable(suffice="图片的宽")
	private Integer photoWidth;

	public String getResUrl() {
		return resUrl;
	}

	public void setResUrl(String resUrl) {
		this.resUrl = resUrl;
	}

	public String getOriginUrl() {
		return originUrl;
	}

	public void setOriginUrl(String originUrl) {
		this.originUrl = originUrl;
	}

	public ResourseType getType() {
		return type;
	}

	public void setType(ResourseType type) {
		this.type = type;
	}

	public int getSize() {
		return size;
	}

	public void setSize(int size) {
		this.size = size;
	}

	public Integer getOwnerId() {
		return ownerId;
	}

	public void setOwnerId(Integer ownerId) {
		this.ownerId = ownerId;
	}

	public Boolean getHistory() {
		return history;
	}

	public void setHistory(Boolean history) {
		this.history = history;
	}

	public String getFileType() {
		return fileType;
	}

	public void setFileType(String fileType) {
		this.fileType = fileType;
	}

	public String getSuffix() {
		return suffix;
	}

	public void setSuffix(String suffix) {
		this.suffix = suffix;
	}

	public String getVideoCover() {
		return videoCover;
	}

	public void setVideoCover(String videoCover) {
		this.videoCover = videoCover;
	}

	public Integer getPhotoHeight() {
		return photoHeight;
	}

	public void setPhotoHeight(Integer photoHeight) {
		this.photoHeight = photoHeight;
	}

	public Integer getPhotoWidth() {
		return photoWidth;
	}

	public void setPhotoWidth(Integer photoWidth) {
		this.photoWidth = photoWidth;
	}
	
	/**
	 * 显示图片的资源
	 * 如果是视频就显示封面
	 * @return
	 */
	public String showPhotoRes(){
		if(ResourseType.video.equals(type)){
			return videoCover;
		}else if(ResourseType.photo.equals(type)){
			return resUrl;
		}
		return null;
	}
	
	/**
	 * 是不是有可以查看的图片
	 * @return
	 */
	public boolean haveShowPhoto(){
		return showPhotoRes()!=null;
	}
	
	
	//TODO 记录一个资源是不是被导入成功了进度是多少
	
	
	
	

}
