package com.mini.mshow.model.dto;

import com.mini.mshow.model.dto.CollectNodeEntity;
import org.jsoup.nodes.Document;

import java.util.List;
import java.util.stream.Collectors;

public class CollectRouteEntity {
    private String urlMatch;
    private List<DocMatch>  docMatch;

    public class DocMatch {
        private String ruleNode;
        private String compare;
        private String rule;

        public Boolean checkDocMatch(Document document, CollectNodeEntity collectNodeEntity) {
            return document.select(collectNodeEntity.getExec().getSelect()).stream().filter(
                    v -> v.text().equals(compare)).collect(Collectors.toList()).size() > 0;
        }

        public String getRuleNode() {
            return ruleNode;
        }

        public void setRuleNode(String ruleNode) {
            this.ruleNode = ruleNode;
        }

        public String getCompare() {
            return compare;
        }

        public void setCompare(String compare) {
            this.compare = compare;
        }

        public String getRule() {
            return rule;
        }

        public void setRule(String rule) {
            this.rule = rule;
        }
    }

    private String rule;
    private String dName;

    public String getUrlMatch() {
        return urlMatch;
    }

    public void setUrlMatch(String urlMatch) {
        this.urlMatch = urlMatch;
    }

    public List<DocMatch> getDocMatch() {
        return docMatch;
    }

    public void setDocMatch(List<DocMatch> docMatch) {
        this.docMatch = docMatch;
    }

    public String getRule() {
        return rule;
    }

    public void setRule(String rule) {
        this.rule = rule;
    }

    public String getdName() {
        return dName;
    }

    public void setdName(String dName) {
        this.dName = dName;
    }
}
