package com.mini.mshow.model.dto.transfer;

import java.util.List;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.string.GsonUtil;
import com.mini.mshow.model.dbto.site.SubjectActivityDbto;
import com.mini.mshow.model.dbto.site.SubjectAlbumDbto;
import com.mini.mshow.model.dbto.site.SubjectAlbumPhotoDbto;
import com.mini.mshow.model.dbto.site.SubjectSpecialDbto;

public class MshowTransferData {
	
	/**
	 * 名片首页
	 */
	private String pcardIndex;

	/**
	 * 各个活动
	 */
	private List<SubjectActivityDbto> activitys;

	/**
	 * 各个相册
	 */
	private List<SubjectAlbumDbto> albums;

	/**
	 * 各个相片
	 */
	private List<SubjectAlbumPhotoDbto> photos;

	/**
	 * 各个专题
	 */
	private List<SubjectSpecialDbto> specials;
	

	public String getPcardIndex() {
		return pcardIndex;
	}
	
	public void setPcardIndex(String pcardIndex) {
		this.pcardIndex = pcardIndex;
	}


	public List<SubjectActivityDbto> getActivitys() {
		return activitys;
	}

	public void setActivitys(List<SubjectActivityDbto> activitys) {
		this.activitys = activitys;
	}

	public List<SubjectAlbumDbto> getAlbums() {
		return albums;
	}

	public void setAlbums(List<SubjectAlbumDbto> albums) {
		this.albums = albums;
	}

	public List<SubjectAlbumPhotoDbto> getPhotos() {
		return photos;
	}

	public void setPhotos(List<SubjectAlbumPhotoDbto> photos) {
		this.photos = photos;
	}

	public List<SubjectSpecialDbto> getSpecials() {
		return specials;
	}

	public void setSpecials(List<SubjectSpecialDbto> specials) {
		this.specials = specials;
	}
	
	public String toJson(){
		return GsonUtil.buildMilliSecondDateGson().toJson(this);
	}
	

	public static MshowTransferData fromJson(String json){
		AssertUtil.assertMethodRequire(json, "json");
		return GsonUtil.buildMilliSecondDateGson().fromJson(json, MshowTransferData.class);
	}
	
	
}
