package com.mini.mshow.model.dbto.site;

import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.framework.model.role.write.Insertable;

/**
 * 用户线下订单的记录 这个用户员工在线下收了钱，然后给用户开单的情况
 * 
 * @author jayheo
 *
 */
public class AccessStaffOfflineOrderRecordDbto extends DbtoIntEntity {

	/**
	 * 
	 */
	private static final long serialVersionUID = -7437617062924458217L;

	/**
	 * 员工的id
	 */
	@Insertable(require="员工id")
	private Integer staffId;

	/**
	 * 员工对应的用户id
	 */
	@Insertable(require="员工用户id")
	private Integer staffUserId;

	/**
	 * 订单价格
	 */
	@Insertable(require="订单价格")
	private Integer money;
	
	/**
	 * 使用前剩余的金额
	 * 这个记下来方便查账
	 */
	@Insertable(require="使用前剩余的金额")
	private Integer beforeSurplus;

	/**
	 * 产品订单的id
	 */
	@Insertable(require="产品订单的id")
	private Integer productOrderId;
	
	
	/**
	 * 应用于哪个用户
	 */
	@Insertable(require="应用于哪个用户")
	private Integer applyUserId;

	public Integer getStaffId() {
		return staffId;
	}

	public void setStaffId(Integer staffId) {
		this.staffId = staffId;
	}

	public Integer getStaffUserId() {
		return staffUserId;
	}

	public void setStaffUserId(Integer staffUserId) {
		this.staffUserId = staffUserId;
	}

	public Integer getMoney() {
		return money;
	}

	public void setMoney(Integer money) {
		this.money = money;
	}

	public Integer getProductOrderId() {
		return productOrderId;
	}

	public void setProductOrderId(Integer productOrderId) {
		this.productOrderId = productOrderId;
	}

	public Integer getBeforeSurplus() {
		return beforeSurplus;
	}

	public void setBeforeSurplus(Integer beforeSurplus) {
		this.beforeSurplus = beforeSurplus;
	}

	public Integer getApplyUserId() {
		return applyUserId;
	}

	public void setApplyUserId(Integer applyUserId) {
		this.applyUserId = applyUserId;
	}
	
}
