package com.mini.mshow.model.dbto.site;

import java.util.List;
import java.util.Optional;

import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.framework.model.role.write.Insertable;
import com.mini.framework.model.role.write.Updatable;
import com.mini.mshow.model.dbto.able.HaveBanners;
import com.mini.mshow.model.dbto.able.HaveGoods;
import com.mini.mshow.model.dbto.able.IsOneSubject;
import com.mini.mshow.model.dto.multi.MultiFactory;
import com.mini.mshow.model.type.SubjectType;

/**
 * 用户的商品
 * @author jayheo
 *
 */
public class SubjectGoodsDbto extends DbtoIntEntity implements HaveGoods,IsOneSubject,HaveBanners{

	/**
	 * 
	 */
	private static final long serialVersionUID = 6149160031081726843L;

	
	public SubjectOverviewDbto tryFindOverview(){
		boolean right = MultiFactory.validate(multiContent);
		SubjectOverviewDbto overview = null;
		if(right){
			overview = SubjectOverviewDbto.findOverview(MultiFactory.fromJson(multiContent),200);
		}else{
			overview = new SubjectOverviewDbto();
		}
		overview.onImportantPhotoFound(Optional.ofNullable(cover));
		overview.setTitle(title);
		// TODO 如果活动有封面应该弄去上
		return overview.fillSubjectField(this);
	}

	@Updatable(suffice="bannerids")
	public String bannerIds;
	
	/**
	 * 标题
	 */
	@Insertable(require="商品标题",minLength=2,maxLength=100)
	@Updatable(suffice="商品标题",minLength=2,maxLength=100)
	private String title;

	
	/**
	 * 实际售价
	 */
	@Updatable(suffice="实际售价")
	@Insertable(require="实际售价")
	private Integer salePrice;
	

	/**
	 * 原始价格
	 * 如果为空就不显示原始价格
	 */
	@Updatable(suffice="原始价格")
	private Integer originalPrice;

	/**
	 * 复杂的内容
	 */
	@Insertable(require="活动多媒体")
	@Updatable(suffice="活动多媒体")
	private String multiContent;
	
	/**
	 * 作者的用户 id
	 */
	@Insertable(require="商品的拥有者")
	@Updatable(forbid="商品的拥有者")
	private Integer authorId;

	@Updatable(suffice="封面")
	private String cover;
	
	/**
	 * 如果当前是置顶状态显示最后一次置顶的时间
	 * 最后一次置顶的时间
	 */
	@Updatable(suffice="置顶")
	private Boolean topShow;
	
	@Updatable(suffice="置顶排序器")
	private Double topShowSorter;
	

	/**
	 * 排序依据
	 */
	@Updatable(suffice="排序依据")
	private Double sorter;
	
	
	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getMultiContent() {
		return multiContent;
	}

	public void setMultiContent(String multiContent) {
		this.multiContent = multiContent;
	}

	
	public String getCover() {
		return cover;
	}

	public void setCover(String cover) {
		this.cover = cover;
	}
	
	public Boolean getTopShow() {
		return topShow;
	}

	public void setTopShow(Boolean topShow) {
		this.topShow = topShow;
	}

	public Double getTopShowSorter() {
		return topShowSorter;
	}

	public void setTopShowSorter(Double topShowSorter) {
		this.topShowSorter = topShowSorter;
	}

	public Double getSorter() {
		return sorter;
	}

	public void setSorter(Double sorter) {
		this.sorter = sorter;
	}
	
	public Integer getSalePrice() {
		return salePrice;
	}

	public void setSalePrice(Integer salePrice) {
		this.salePrice = salePrice;
	}

	public Integer getOriginalPrice() {
		return originalPrice;
	}

	public void setOriginalPrice(Integer originalPrice) {
		this.originalPrice = originalPrice;
	}

	public Integer getAuthorId() {
		return authorId;
	}

	public void setAuthorId(Integer authorId) {
		this.authorId = authorId;
	}
	
	public String getBannerIds() {
		return bannerIds;
	}

	public void setBannerIds(String bannerIds) {
		this.bannerIds = bannerIds;
	}

	@Override
	public SubjectType showSubectType() {
		return SubjectType.activity;
	}

	@Override
	public Integer showSubjectId() {
		return getId();
	}
	
	
	/**
	 * 把MultiContent忽略掉
	 * @return 
	 */
	public SubjectGoodsDbto skipMulti(){
		this.setMultiContent(null);
		return this;
	}
	
	public SubjectGoodsDbto copy(){
		SubjectGoodsDbto copyActivity = new SubjectGoodsDbto();
		copyActivity.setTitle(this.getTitle());
		copyActivity.setMultiContent(this.getMultiContent());
		copyActivity.setCover(this.getCover());
		return copyActivity;
	}

	
	/**
	 * 判断有没有topShow的参数
	 * @return
	 */
	public boolean ifTopShowParams(){
		return topShow!=null || topShowSorter!=null;
	}

	@Override
	public Integer showGoodsId() {
		return getId();
	}

	@Override
	public Integer showAuthorId() {
		return authorId;
	}
	
	@Override
	public List<Integer> showBannerIds() {
		return showBannerIds(this.bannerIds, parseIdFn);
	}

}
