/*
 * Decompiled with CFR 0.152.
 */
package com.mini.mshow.model.type;

import com.mini.trace.model.type.ActionBehaviourType;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SubjectInteractType {
    browse("\u6d4f\u89c8"),
    share("\u5206\u4eab"),
    collect("\u6536\u85cf"),
    praise("\u70b9\u8d5e"),
    copyFrom("\u590d\u5236\u6e90\u7aef"),
    copyAs("\u590d\u5236\u7ed3\u679c"),
    enlist("\u62a5\u540d");

    private String title;

    private SubjectInteractType(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public static List<SubjectInteractType> canCancelTypes() {
        return Stream.of(collect, praise).collect(Collectors.toList());
    }

    public boolean canCancel() {
        return SubjectInteractType.canCancelTypes().contains((Object)this);
    }

    public Optional<ActionBehaviourType> mapToBehaviour() {
        switch (this) {
            case browse: {
                return Optional.of(ActionBehaviourType.browse);
            }
            case collect: {
                return Optional.of(ActionBehaviourType.collect);
            }
            case praise: {
                return Optional.of(ActionBehaviourType.praise);
            }
            case share: {
                return Optional.of(ActionBehaviourType.share);
            }
            case enlist: {
                return Optional.of(ActionBehaviourType.enlist);
            }
        }
        return Optional.empty();
    }
}

