package com.mini.mshow.model.dbto.site;

import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.framework.model.role.write.Insertable;
import com.mini.framework.model.role.write.Updatable;
import com.mini.mshow.model.dbto.able.HaveAuthor;
import com.mini.mshow.model.type.SubjectType;

/**
 * 商城的banner
 * @author jayheo
 *
 */
public class MallBannerDbto extends DbtoIntEntity implements HaveAuthor {

	/**
	 * 
	 */
	private static final long serialVersionUID = -531963381846459405L;

	/**
	 * 对应的主题id
	 */
	private Integer subjectId;
	
	/**
	 * 对应的跳转主题类型
	 */
	@Insertable(require = "新增banner需要subjectType")
	@Updatable(suffice = "更新banner需要authorId")
	private SubjectType subjectType;

	/**
	 * 封面的图片资源
	 */
	@Insertable(require = "新增banner需要coverResourse")
	@Updatable(suffice = "更新banner需要coverResourse")
	private String coverResourse;
	
	/**
	 * 冗余作者id，方便后面统计
	 */
	@Insertable(require = "新增banner需要authorId")
	@Updatable(suffice = "更新banner需要authorId")
	private Integer authorId;

	public Integer getSubjectId() {
		return subjectId;
	}

	public void setSubjectId(Integer subjectId) {
		this.subjectId = subjectId;
	}

	public SubjectType getSubjectType() {
		return subjectType;
	}

	public void setSubjectType(SubjectType subjectType) {
		this.subjectType = subjectType;
	}

	public String getCoverResourse() {
		return coverResourse;
	}

	public void setCoverResourse(String coverResourse) {
		this.coverResourse = coverResourse;
	}

	public Integer getAuthorId() {
		return authorId;
	}

	public void setAuthorId(Integer authorId) {
		this.authorId = authorId;
	}

	@Override
	public Integer showAuthorId() {
		return this.authorId;
	}
}
