package com.mini.mshow.model.dbto.able;

/**
 * 支持赞的统计的
 * @author jayheo
 *
 */
public interface SupportPraiseStatistics extends SupportCancelStatistics{

	public Integer getPraisedNum() ;

	public void setPraisedNum(Integer praisedNum) ;

	public Integer getCancelPraisedNum() ;

	public void setCancelPraisedNum(Integer cancelPraisedNum) ;

	public Integer getAllPraisedNum() ;

	public void setAllPraisedNum(Integer allPraisedNum) ;

	default public void atomSwitchPraise(boolean cancel) {
		if(cancel){
			atomCancelPraise();
		}else{
			atomIncreasePraise();
		}
	}
	
	default public void atomCancelPraise(){
		atomCancelPraise(1);
	}
	
	default public void atomCancelPraise(Integer increment){
		valiIncrement(increment);
		setPraisedNum( -increment);
		setCancelPraisedNum( increment);
	}
	
	default public void atomIncreasePraise(){
		atomIncreasePraise(1);
	}
	default public void atomIncreasePraise(Integer increment){
		valiIncrement(increment);
		setPraisedNum(increment);
		setAllPraisedNum(increment);
	}
}
