package com.mini.mshow.model.dbto.paas;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.builder.ToStringBuilder;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.mini.framework.core.exception.HandleStringJsonException;
import com.mini.framework.core.status.Status.Busy;
import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.framework.model.role.write.Insertable;
import com.mini.framework.model.role.write.Updatable;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.oss.OssWatermarkReplace;
import com.mini.mshow.model.type.ShareObjectType;

/**
 * 小程序在群或者好友中转发的时候，中间会有个5比4的图片窗口<br>
 * 这里可以生成图片，还要写一些文字，这是一个模板方便生成
 * 
 * @author jayheo
 *
 */
public class SiteMappShareFrameTemplateDbto extends DbtoIntEntity {

	/**
	 * 
	 */
	private static final long serialVersionUID = 5286762556779600611L;

	@Insertable(require="商家id")
	@Updatable(forbid="商家id")
	private Integer siteId;
	
	/**
	 * 可以转发的实体的类型
	 */
	@Insertable(require="转发的类型")
	@Updatable(forbid="转发的类型")
	private ShareObjectType objectType;

	/**
	 * 模板图片的url
	 */
	@Insertable(require="模板图片的url")
	@Updatable(suffice="模板图片的url")
	private String templatePicUrl;

	/**
	 * 水印的json字段
	 */
	@Insertable(require="水印的json字段")
	@Updatable(suffice="水印的json字段")
	private String watermarksJson;
	
	/**
	 * 使用顺序
	 */
	@Insertable(require="使用顺序")
	@Updatable(suffice="使用顺序")
	private Double useSorter;
	
	/**
	 * 使用状态
	 */
	@Insertable(require="使用状态")
	@Updatable(suffice="使用状态")
	private Boolean useStatus;

	public String getTemplatePicUrl() {
		return templatePicUrl;
	}

	public void setTemplatePicUrl(String templatePicUrl) {
		this.templatePicUrl = templatePicUrl;
	}

	public String getWatermarksJson() {
		return watermarksJson;
	}

	public void setWatermarksJson(String watermarksJson) {
		this.watermarksJson = watermarksJson;
	}

	public ShareObjectType getObjectType() {
		return objectType;
	}

	public void setObjectType(ShareObjectType objectType) {
		this.objectType = objectType;
	}

	public Double getUseSorter() {
		return useSorter;
	}

	public void setUseSorter(Double useSorter) {
		this.useSorter = useSorter;
	}

	public Boolean getUseStatus() {
		return useStatus;
	}

	public void setUseStatus(Boolean useStatus) {
		this.useStatus = useStatus;
	}
	
	public Integer getSiteId() {
		return siteId;
	}

	public void setSiteId(Integer siteId) {
		this.siteId = siteId;
	}

	public boolean ifUse(){
		return useStatus!=null && useStatus;
	}
	
	public Watermarks showWatermarksBean(){
		AssertUtil.assertNotFatal(watermarksJson!=null, Busy.dataUnConfigSite, "水印json为空");
		try{
			return new Gson().fromJson(watermarksJson, SiteMappShareFrameTemplateDbto.Watermarks.class);
		}catch(JsonSyntaxException e){
			throw new HandleStringJsonException(e, "在json对象:[%s]的时候出现语法错误", SiteMappShareFrameTemplateDbto.class.getName());
		}
	}
	
	public SiteMappShareFrameTemplateDbto storeWatermarksJson(Watermarks watermarks){
		AssertUtil.assertMethodRequire(watermarks, "watermarks");
		watermarksJson = new Gson().toJson(watermarks);
		return this;
	}
	
	public static class Watermarks{
		private List<OssWatermarkReplace> marks;

		public List<OssWatermarkReplace> getMarks() {
			return marks;
		}

		public void setMarks(List<OssWatermarkReplace> marks) {
			this.marks = marks;
		}
		
		public void addWatermark(OssWatermarkReplace mark){
			if(marks == null){
				marks = new ArrayList<OssWatermarkReplace>();
			}
			marks.add(mark);
		}
		
		@Override
		public String toString() {
			return ToStringBuilder.reflectionToString(this);
		}
		
	}

	/**
	 * 移动一下水印的位置
	 * @param offset
	 */
	public void moveOffset(int offset) {
		Watermarks watermarks = showWatermarksBean();
		watermarks.marks.forEach(mark->{
			mark.setBase64Offset(mark.getBase64Offset() + offset);
		});
		storeWatermarksJson(watermarks);
	}

}
