package com.mini.mshow.model.dbto.site;

import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.framework.model.role.write.Insertable;
import com.mini.framework.model.role.write.Updatable;
import com.mini.mshow.model.dbto.able.SupportBrowseStatistics;
import com.mini.mshow.model.dbto.able.SupportBuyStatistics;
import com.mini.mshow.model.dbto.able.SupportCollectStatistics;
import com.mini.mshow.model.dbto.able.SupportShareStatistics;

/**
 * 商品的统计数据
 * @author jayheo
 *
 */
public class SubjectGoodsStatisticsDbto extends DbtoIntEntity
implements SupportBrowseStatistics,SupportShareStatistics ,SupportCollectStatistics,SupportBuyStatistics {

	/**
	 * 
	 */
	private static final long serialVersionUID = 595493963351390289L;

	@Insertable(require="商品id")
	@Updatable(forbid="商品id")
	private Integer goodsId;
	
	/**
	 * 作者的用户 id
	 */
	@Insertable(require="商品作者")
	@Updatable(forbid="商品作者")
	private Integer authorId;
	
	@Insertable(require = "被购买数")
	@Updatable(suffice = "被购买数")
	private Integer buyNum;
	/**
	 * 被浏览数
	 */
	@Insertable(require = "被浏览数")
	@Updatable(suffice = "被浏览数")
	private Integer browsedNum;
	
	/**
	 * 被分享数
	 */
	@Insertable(require = "被分享数")
	@Updatable(suffice = "被分享数")
	private Integer sharedNum;
	

	/**
	 * 被收藏数
	 */
	@Insertable(require = "被收藏数")
	@Updatable(suffice = "被收藏数")
	private Integer collectedNum;
	
	

	/**
	 * 总被收藏数
	 */
	@Insertable(require = "总被收藏数")
	@Updatable(suffice = "总被收藏数")
	private Integer allCollectedNum;

	/**
	 * 被取消收藏数
	 */
	@Insertable(require = "被取消收藏数")
	@Updatable(suffice = "被取消收藏数")
	private Integer cancelCollectedNum;


	public Integer getBuyNum() {
		return buyNum;
	}

	public void setBuyNum(Integer buyNum) {
		this.buyNum = buyNum;
	}

	public Integer getBrowsedNum() {
		return browsedNum;
	}

	public void setBrowsedNum(Integer browsedNum) {
		this.browsedNum = browsedNum;
	}

	public Integer getSharedNum() {
		return sharedNum;
	}

	public void setSharedNum(Integer sharedNum) {
		this.sharedNum = sharedNum;
	}

	public Integer getCollectedNum() {
		return collectedNum;
	}

	public void setCollectedNum(Integer collectedNum) {
		this.collectedNum = collectedNum;
	}

	public Integer getAllCollectedNum() {
		return allCollectedNum;
	}

	public void setAllCollectedNum(Integer allCollectedNum) {
		this.allCollectedNum = allCollectedNum;
	}

	public Integer getCancelCollectedNum() {
		return cancelCollectedNum;
	}

	public void setCancelCollectedNum(Integer cancelCollectedNum) {
		this.cancelCollectedNum = cancelCollectedNum;
	}

	public Integer getGoodsId() {
		return goodsId;
	}

	public void setGoodsId(Integer goodsId) {
		this.goodsId = goodsId;
	}

	public Integer getAuthorId() {
		return authorId;
	}

	public void setAuthorId(Integer authorId) {
		this.authorId = authorId;
	}
	
	
	public static SubjectGoodsStatisticsDbto createInit(Integer goodsId, Integer authorId) {
		SubjectGoodsStatisticsDbto init = new SubjectGoodsStatisticsDbto();
		init.goodsId = goodsId;
		init.authorId = authorId;
		return init.initNum();
	}
	
	/**
	 * 把所有的相关记录都设置为0
	 * @return
	 */
	public SubjectGoodsStatisticsDbto initNum() {
		this.buyNum = 0;
		this.collectedNum = 0;
		this.allCollectedNum = 0;
		this.cancelCollectedNum = 0;
		this.browsedNum = 0;
		this.sharedNum = 0;
		return this;
	}
	
}
