package com.mini.mshow.model.dto.multi;

import org.apache.commons.lang3.builder.ToStringBuilder;

import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;

/**
 * @author xzh
 * 内容
 */
public abstract class Content implements Comparable<Content>{

	private MultiContentType type;
	/**
	 * 顺序
	 */
	private double order;
	
	public Content() {
		type = MultiContentType.typeOf(this.getClass());
	}
	
	public double getOrder() {
		return order;
	}
	public void setOrder(double order) {
		this.order = order;
	}
	
	public MultiContentType getType() {
		return type;
	}
	public void setType(MultiContentType type) {
		this.type = type;
	}
	
	public boolean matchType(MultiContentType match){
		AssertUtil.assertMethodRequire(match, "match");
		return match.equals(type);
	}
	
	public void copyTo(Content copyTo){
		copyTo.order = order;
		copyTo.type = type;
	}
	
	
	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}
	
	
	@Override
	public int compareTo(Content other) {
		if(order ==other.order)return 0;
		return order -other.order>0?1:-1;
	}
	
	@SuppressWarnings("unchecked")
	public <T extends Content> T takeContent(){
		// TODO type不能为空
		String thisClassName = this.getClass().getName();
		AssertUtil.assertNoBadReq(this.getType()!=null, Status.BadReq.illParam,"数据%s没有type", this);
		String typeClassName =this.getType().getType().getName();
		AssertUtil.assertNoBadReq(thisClassName.equals(typeClassName), Status.BadReq.conflictData, "数据格式错误需要检查类:%s的类型不能为%s",thisClassName,typeClassName);
		return (T)this;
	}
	
}
