package com.mini.mshow.model.dbto.site;

import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.framework.model.role.write.Insertable;
import com.mini.framework.model.role.write.Updatable;
import com.mini.mshow.model.dbto.able.HaveAuthor;
import com.mini.mshow.model.dbto.able.HaveSorter;

/**
 * 某相册的相片
 * @author jayheo
 *
 */
public class SubjectAlbumPhotoDbto extends DbtoIntEntity implements HaveAuthor,HaveSorter{

	/**
	 * 
	 */
	private static final long serialVersionUID = 6149160031081726843L;

	
	@Insertable(require="相片标题",minLength=2,maxLength=500)
	@Updatable(suffice="相片标题",minLength=2,maxLength=500)
	private String title;
	
	/**
	 * 拥有者id 冗余这个数字反正不会变的
	 * 也是就作者
	 */
	@Insertable(require="相片作者")
	@Updatable(forbid="相片作者")
	private Integer authorId;
	
	
	/**
	 * 原创的key，标记这个东西是谁
	 * 这个东西用于在复制的时候记录是谁原创的
	 */
	@Insertable(require="原始作者")
	@Updatable(forbid="原始作者")
	private Integer originalAuthorId;

	/**
	 * 相片id 冗余这个数字反正不会变的
	 */
	@Insertable(require="相片所属相册")
	@Updatable(forbid="相片所属相册")
	private Integer albumId;

	/**
	 * 相片资源的地址
	 * 如果是视频这里就是视频的封面
	 */
	@Insertable(require="相片资源地址")
	@Updatable(forbid="相片资源地址")
	private String resUrl;
	
	/**
	 * 资源id
	 */
	@Updatable(forbid="相片资源id")
	private Integer resourseId;
	
	
	/**
	 * 视频状态
	 * 是视频传true
	 * 不是视频传false
	 */
	@Insertable(require="视频状态")
	@Updatable(forbid="视频状态")
	private Boolean videoStatus;
	
	/**
	 * 如果有视频这里显示视频的地址
	 * 视频资源地址
	 */
	@Updatable(suffice="封面资源地址")
	private String coverResUrl;
	
	
	/**
	 * 封面的宽度
	 * 图片的宽度
	 */
	private Integer height;
	
	/**
	 * 封面的高度
	 * 图片的宽度
	 */
	private Integer width;
	
	/**
	 * 排序器
	 * 一般来说新的相册默认放在最前面。
	 */
	@Insertable(require="排序器")
	@Updatable(suffice="排序器")
	private Double sorter;

	// TODO 要把标签值和标签数弄出来

	public Integer getAlbumId() {
		return albumId;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public Integer getAuthorId() {
		return authorId;
	}

	public void setAuthorId(Integer authorId) {
		this.authorId = authorId;
	}

	public void setAlbumId(Integer albumId) {
		this.albumId = albumId;
	}

	public String getResUrl() {
		return resUrl;
	}

	public void setResUrl(String resUrl) {
		this.resUrl = resUrl;
	}

	public Integer getResourseId() {
		return resourseId;
	}

	public void setResourseId(Integer resourseId) {
		this.resourseId = resourseId;
	}

	public Integer getOriginalAuthorId() {
		return originalAuthorId;
	}

	public void setOriginalAuthorId(Integer originalAuthorId) {
		this.originalAuthorId = originalAuthorId;
	}
	
	public Boolean getVideoStatus() {
		return videoStatus;
	}

	public void setVideoStatus(Boolean videoStatus) {
		this.videoStatus = videoStatus;
	}

	public String getCoverResUrl() {
		return coverResUrl;
	}

	public void setCoverResUrl(String coverResUrl) {
		this.coverResUrl = coverResUrl;
	}

	public Integer getHeight() {
		return height;
	}

	public void setHeight(Integer height) {
		this.height = height;
	}

	public Integer getWidth() {
		return width;
	}

	public void setWidth(Integer width) {
		this.width = width;
	}

	public Double getSorter() {
		return sorter;
	}

	public void setSorter(Double sorter) {
		this.sorter = sorter;
	}

	/**
	 * 是不是视频状态，默认是的
	 * @return
	 */
	public boolean videoStatus(){
		return videoStatus==null || videoStatus;
	}

	@Override
	public Integer showAuthorId() {
		return authorId;
	}
	
	public boolean haveRealPhoto(){
		return showRealPhoto()!=null;
	}
	
	public String showRealPhoto(){
		if (videoStatus()) {
			return coverResUrl;
		}else{
			return resUrl;
		}
	}

	@Override
	public Double showSorter() {
		return sorter;
	}
	

}
