package com.mini.mshow.model.dbto.site;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

import com.mini.framework.core.status.Status;
import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.framework.model.role.write.Insertable;
import com.mini.framework.model.role.write.Updatable;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.asserts.JudgeUtil;
import com.mini.framework.util.asserts.Require;
import com.mini.mshow.model.dbto.able.HaveGoods;
import com.mini.mshow.model.dbto.able.HaveMultiContent;
import com.mini.mshow.model.dbto.able.IsOneSubject;
import com.mini.mshow.model.dto.multi.MultiFactory;
import com.mini.mshow.model.type.SubjectType;

/**
 * 用户的商品
 * @author jayheo
 *
 */
public class SubjectGoodsDbto extends DbtoIntEntity implements HaveGoods,IsOneSubject,HaveMultiContent{

	/**
	 * 
	 */
	private static final long serialVersionUID = 6149160031081726843L;

	
	public SubjectOverviewDbto tryFindOverview(){
		boolean right = MultiFactory.validate(multiContent);
		SubjectOverviewDbto overview = null;
		if(right){
			overview = SubjectOverviewDbto.findOverview(MultiFactory.fromJson(multiContent),200);
		}else{
			overview = new SubjectOverviewDbto();
		}
		
		List<String> coverPhones = new ArrayList<>(Arrays.asList(covers));
		Collections.reverse(coverPhones);
		coverPhones.add(cover);
		coverPhones = coverPhones.stream().distinct().filter(Objects::nonNull).collect(Collectors.toList());
		
		for (String coverPhone : coverPhones) {
			overview.onImportantPhotoFound(Optional.ofNullable(coverPhone));
		}
		overview.setTitle(title);
		return overview.fillSubjectField(this);
	}


	/**
	 * 标题
	 */
	@Insertable(require="商品标题",minLength=2,maxLength=100)
	@Updatable(suffice="商品标题",minLength=2,maxLength=100)
	private String title;
	
	/**
	 * 选项参数
	 */
	@Updatable(suffice="选项参数")
	private String options;

	
	/**
	 * 实际售价
	 */
	@Updatable(suffice="实际售价")
	@Insertable(require="实际售价")
	private Integer salePrice;
	

	/**
	 * 原始价格
	 * 如果为空就不显示原始价格
	 */
	@Updatable(suffice="原始价格")
	private Integer originalPrice;

	/**
	 * 复杂的内容
	 */
	@Insertable(require="活动多媒体")
	@Updatable(suffice="活动多媒体")
	private String multiContent;
	
	/**
	 * 作者的用户 id
	 */
	@Insertable(require="商品的拥有者")
	@Updatable(forbid="商品的拥有者")
	private Integer authorId;

	@Updatable(suffice="封面")
	@Insertable(require = "封面")
	private String cover;
	
	/**
	 * 如果当前是置顶状态显示最后一次置顶的时间
	 * 最后一次置顶的时间
	 */
	@Updatable(suffice="置顶")
	private Boolean topShow;
	
	@Updatable(suffice="置顶排序器")
	private Double topShowSorter;
	

	/**
	 * 排序依据
	 */
	@Updatable(suffice="排序依据")
	@Insertable(require="排序依据")
	private Double sorter;

	@Updatable(suffice = "轮播图")
	@Insertable(require = "轮播图")
	private String covers;

	@Updatable(suffice = "使用状态")
	@Insertable(require = "使用状态")
	private Boolean useStatus;
	
	
	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getMultiContent() {
		return multiContent;
	}

	public void setMultiContent(String multiContent) {
		this.multiContent = multiContent;
	}

	
	public String getCover() {
		return cover;
	}

	public void setCover(String cover) {
		this.cover = cover;
	}

	public Boolean getUseStatus() {
		return useStatus;
	}

	public void setCovers(String covers) {
		this.covers = covers;
	}

	public void setUseStatus(Boolean useStatus) {
		this.useStatus = useStatus;
	}

	public String getCovers() {
		return covers;
	}

	public Boolean getTopShow() {
		return topShow;
	}

	public void setTopShow(Boolean topShow) {
		this.topShow = topShow;
	}

	public Double getTopShowSorter() {
		return topShowSorter;
	}

	public void setTopShowSorter(Double topShowSorter) {
		this.topShowSorter = topShowSorter;
	}

	public Double getSorter() {
		return sorter;
	}

	public void setSorter(Double sorter) {
		this.sorter = sorter;
	}
	
	public Integer getSalePrice() {
		return salePrice;
	}

	public void setSalePrice(Integer salePrice) {
		this.salePrice = salePrice;
	}

	public Integer getOriginalPrice() {
		return originalPrice;
	}

	public void setOriginalPrice(Integer originalPrice) {
		this.originalPrice = originalPrice;
	}

	public Integer getAuthorId() {
		return authorId;
	}

	public void setAuthorId(Integer authorId) {
		this.authorId = authorId;
	}


	public String getOptions() {
		return options;
	}

	public void setOptions(String options) {
		this.options = options;
	}

	@Override
	public SubjectType showSubectType() {
		return SubjectType.goods;
	}

	@Override
	public Integer showSubjectId() {
		return getId();
	}
	
	
	/**
	 * 把MultiContent忽略掉
	 * @return 
	 */
	public SubjectGoodsDbto skipMulti(){
		this.setMultiContent(null);
		return this;
	}
	
	public SubjectGoodsDbto copy(){
		SubjectGoodsDbto copyActivity = new SubjectGoodsDbto();
		copyActivity.setTitle(this.getTitle());
		copyActivity.setMultiContent(this.getMultiContent());
		copyActivity.setCover(this.getCover());
		return copyActivity;
	}

	
	/**
	 * 判断有没有topShow的参数
	 * @return
	 */
	public boolean ifTopShowParams(){
		return topShow!=null || topShowSorter!=null;
	}

	@Override
	public Integer showGoodsId() {
		return getId();
	}

	@Override
	public Integer showAuthorId() {
		return authorId;
	}
	
	/**
	 * 检查价格是不合理的
	 */
	public boolean validatePrice(boolean ignoreAssert){
		boolean match = originalPrice==null || salePrice==null || originalPrice>=salePrice;
		AssertUtil.assertNoBadReq(ignoreAssert || match, Status.BadReq.illParam, "原价originalPrice:[%s]不能小于售价salePrice:[%s]", originalPrice,salePrice);
		match &= originalPrice==null || originalPrice>=0;
		match &= salePrice==null || salePrice>=0;
		AssertUtil.assertNoBadReq(ignoreAssert || match, Status.BadReq.illParam, "原价originalPrice:[%s]和salePrice:[%s]都不能小于0", originalPrice,salePrice);
		return match;
	}
	
	/**
	 * 检查cover和covers
	 * @param ignoreAssert
	 * @return
	 */
	public boolean validateCover(Optional<Predicate<String>> validateUrlOptional,boolean ignoreAssert){
		AssertUtil.assertMethodRequire(validateUrlOptional, "validateUrlOptional");
		boolean match = cover!=null&& cover.length()>0;
		AssertUtil.assertNoBadReq(ignoreAssert || match, Status.BadReq.noReq, "封面cover:[%s]不能为空",cover);
		if(!ignoreAssert && validateUrlOptional.isPresent()){
			match &= validateUrlOptional.get().test(cover);
		};
		AssertUtil.assertNoBadReq(ignoreAssert || match, Status.BadReq.illParam, "封面cover:[%s]必须能访问",cover);
		match &= covers!=null;
		AssertUtil.assertNoBadReq(ignoreAssert || match, Status.BadReq.noReq, "covers不能为空");
		match &= JudgeUtil.match(covers.split(",").length, Require.between, 1,11);
		AssertUtil.assertNoBadReq(ignoreAssert || match, Status.BadReq.illParam, "covers个数必须介于[0,10]");
		if(!ignoreAssert && validateUrlOptional.isPresent()){
			for (String c : covers.split(",")) {
				match &= validateUrlOptional.get().test(c);
				AssertUtil.assertNoBadReq(ignoreAssert || match, Status.BadReq.illParam, "轮播图[%s]必须能访问",c);
			}
		}
		return match;
	}

}
