/*
 * Decompiled with CFR 0.152.
 */
package com.mini.mshow.model.dbto.site;

import com.mini.framework.core.exception.standard.UnsupportedException;
import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.framework.model.role.write.Insertable;
import com.mini.framework.model.role.write.Updatable;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.mshow.model.dbto.able.SupportBrowseStatistics;
import com.mini.mshow.model.dbto.able.SupportCollectStatistics;
import com.mini.mshow.model.dbto.able.SupportShareStatistics;
import com.mini.mshow.model.type.SubjectInteractType;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MshowPcardStatisticsDbto
extends DbtoIntEntity
implements SupportBrowseStatistics,
SupportShareStatistics,
SupportCollectStatistics {
    private static final long serialVersionUID = 1021596008658608355L;
    @Insertable(require="\u4e2a\u4eba\u540d\u7247id")
    @Updatable(forbid="\u4e2a\u4eba\u540d\u7247id")
    private Integer pcardId;
    @Insertable(require="\u62e5\u6709\u8005id")
    @Updatable(forbid="\u62e5\u6709\u8005id")
    private Integer ownerId;
    @Insertable(require="\u88ab\u6d4f\u89c8\u6570")
    @Updatable(suffice="\u88ab\u6d4f\u89c8\u6570")
    private Integer browsedNum;
    @Insertable(require="\u88ab\u5206\u4eab\u6570")
    @Updatable(suffice="\u88ab\u5206\u4eab\u6570")
    private Integer sharedNum;
    @Insertable(require="\u88ab\u6536\u85cf\u6570")
    @Updatable(suffice="\u88ab\u6536\u85cf\u6570")
    private Integer collectedNum;
    @Insertable(require="\u603b\u88ab\u6536\u85cf\u6570")
    @Updatable(suffice="\u603b\u88ab\u6536\u85cf\u6570")
    private Integer allCollectedNum;
    @Insertable(require="\u88ab\u53d6\u6d88\u6536\u85cf\u6570")
    @Updatable(suffice="\u88ab\u53d6\u6d88\u6536\u85cf\u6570")
    private Integer cancelCollectedNum;
    @Insertable(require="\u6d3b\u8dc3\u6307\u6570")
    @Updatable(suffice="\u6d3b\u8dc3\u6307\u6570")
    private Integer actionNum;

    public Integer getPcardId() {
        return this.pcardId;
    }

    public void setPcardId(Integer pcardId) {
        this.pcardId = pcardId;
    }

    @Override
    public Integer getBrowsedNum() {
        return this.browsedNum;
    }

    @Override
    public void setBrowsedNum(Integer browsedNum) {
        this.browsedNum = browsedNum;
    }

    @Override
    public Integer getSharedNum() {
        return this.sharedNum;
    }

    @Override
    public void setSharedNum(Integer sharedNum) {
        this.sharedNum = sharedNum;
    }

    @Override
    public Integer getCollectedNum() {
        return this.collectedNum;
    }

    @Override
    public void setCollectedNum(Integer collectedNum) {
        this.collectedNum = collectedNum;
    }

    @Override
    public Integer getCancelCollectedNum() {
        return this.cancelCollectedNum;
    }

    @Override
    public void setCancelCollectedNum(Integer cancelCollectedNum) {
        this.cancelCollectedNum = cancelCollectedNum;
    }

    public Integer getActionNum() {
        return this.actionNum;
    }

    public MshowPcardStatisticsDbto setActionNum(Integer actionNum) {
        this.actionNum = actionNum;
        return this;
    }

    @Override
    public Integer getAllCollectedNum() {
        return this.allCollectedNum;
    }

    @Override
    public void setAllCollectedNum(Integer allCollectedNum) {
        this.allCollectedNum = allCollectedNum;
    }

    public Integer getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(Integer ownerId) {
        this.ownerId = ownerId;
    }

    public static MshowPcardStatisticsDbto createInit(int pcardId, int ownerId) {
        MshowPcardStatisticsDbto init = new MshowPcardStatisticsDbto();
        init.pcardId = pcardId;
        init.ownerId = ownerId;
        return init.initNum();
    }

    public MshowPcardStatisticsDbto initNum() {
        this.sharedNum = 0;
        this.collectedNum = 0;
        this.allCollectedNum = 0;
        this.cancelCollectedNum = 0;
        this.browsedNum = 0;
        this.actionNum = 0;
        return this;
    }

    public int showStatisticsNum(SubjectInteractType interactType) {
        switch (interactType) {
            case browse: {
                return this.browsedNum;
            }
            case share: {
                return this.sharedNum;
            }
            case collect: {
                return this.collectedNum;
            }
        }
        throw new UnsupportedException("\u6d3b\u52a8\u6682\u65f6\u4e0d\u662f\u652f\u6301%s\u7684\u589e\u91cf", new Object[]{interactType});
    }

    public static boolean supportStatistics(SubjectInteractType interactType) {
        AssertUtil.assertMethodRequire((Object)((Object)interactType), (String)"interactType");
        return Stream.of(SubjectInteractType.browse, SubjectInteractType.share, SubjectInteractType.collect).collect(Collectors.toSet()).contains((Object)interactType);
    }

    public static MshowPcardStatisticsDbto createAtomByInteract(SubjectInteractType interactType, boolean cancel) {
        AssertUtil.assertMethodRequire((Object)((Object)interactType), (String)"interactType");
        MshowPcardStatisticsDbto atom = new MshowPcardStatisticsDbto();
        switch (interactType) {
            case browse: {
                atom.atomIncreaseBrowse();
                break;
            }
            case share: {
                atom.atomIncreaseShare();
                break;
            }
            case collect: {
                atom.atomSwitchCollect(cancel);
                break;
            }
            default: {
                throw new UnsupportedException("\u540d\u7247\u6682\u65f6\u4e0d\u662f\u652f\u6301%s\u7684\u589e\u91cf", new Object[]{interactType});
            }
        }
        return atom;
    }
}

