package com.mini.mshow.model.dbto.site;

import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.framework.model.role.write.Insertable;
import com.mini.framework.model.role.write.Updatable;
import com.mini.mshow.model.dbto.able.HaveAuthor;
import com.mini.mshow.model.dto.transfer.SubjectKeyDto;
import com.mini.mshow.model.type.SubjectType;

/**
 * 商城的banner
 * @author jayheo
 *
 */
public class MallBannerDbto extends DbtoIntEntity implements HaveAuthor {

	/**
	 * 
	 */
	private static final long serialVersionUID = -531963381846459405L;

	/**
	 * 对应的主题id
	 */
	@Insertable(require = "banner跳转主题id")
	@Updatable(forbid = "banner跳转主题id")
	private Integer subjectId;
	
	/**
	 * 对应的跳转主题类型
	 */
	@Insertable(require = "banner跳转主题类型")
	@Updatable(forbid = "banner跳转主题类型")
	private SubjectType subjectType;

	/**
	 * 封面的图片资源
	 */
	@Insertable(require = "banner的封面")
	@Updatable(suffice = "banner的封面")
	private String coverResourse;
	
	/**
	 * 冗余作者id，方便后面统计
	 */
	@Insertable(require = "banner作者")
	@Updatable(forbid = "banner作者")
	private Integer authorId;
	

	@Insertable(require = "banner顺序")
	@Updatable(suffice = "banner顺序")
	private Double sorter;

	public Integer getSubjectId() {
		return subjectId;
	}

	public void setSubjectId(Integer subjectId) {
		this.subjectId = subjectId;
	}

	public SubjectType getSubjectType() {
		return subjectType;
	}

	public void setSubjectType(SubjectType subjectType) {
		this.subjectType = subjectType;
	}

	public String getCoverResourse() {
		return coverResourse;
	}

	public void setCoverResourse(String coverResourse) {
		this.coverResourse = coverResourse;
	}

	public Integer getAuthorId() {
		return authorId;
	}

	public void setAuthorId(Integer authorId) {
		this.authorId = authorId;
	}
	
	public Double getSorter() {
		return sorter;
	}

	public void setSorter(Double sorter) {
		this.sorter = sorter;
	}

	public SubjectKeyDto showSubjectKey(){
		return new SubjectKeyDto(subjectType,subjectId);
	}

	@Override
	public Integer showAuthorId() {
		return this.authorId;
	}
}
