package com.mini.mshow.model.dbto.able;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;

import com.mini.framework.core.exception.BadDataException;
import com.mini.framework.core.status.Status;

public interface HaveBanners {

	default Set<Integer> showBannerIdSet(){
		return new HashSet<>(showBannerIds());
	}
	
	List<Integer> showBannerIds();
	
	BiFunction<String, String, Integer> parseIdFn =(item,string) ->{
		try {
			return Integer.parseInt(item);
		} catch (NumberFormatException e) {
			throw new BadDataException(Status.BadData.DataIncomplete,"字符:[%s]中的:[%s]不能转成数字", string,item);
		}
	};
	
	default List<Integer> showBannerIds(String idString,BiFunction<String, String, Integer> parseIdFn){
		List<Integer> list = new ArrayList<Integer>();
		
		if(idString==null){
			return list;
		}
		String[] ids = idString.split(",");
		for (String id : ids) {
			list.add(parseIdFn.apply(id,idString));
		}
		return list;
	}
}
