package com.mini.mshow.model.dto.transfer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.mshow.model.type.SubjectType;

/**
 * 主题映射
 * @author jayheo
 *
 */
public class SubjectMapper {

	private HashMap<String, SubjectKeyDto> mapper = new LinkedHashMap<>();

	public void putSubjectMapper(SubjectType oldSubjectType, Integer oldSubjectId, SubjectType newSubjectType,
			Integer newSubjectId) {
		SubjectKeyDto oldSubject = new SubjectKeyDto(oldSubjectType, oldSubjectId);
		SubjectKeyDto newSubject = new SubjectKeyDto(newSubjectType, newSubjectId);
		putSubjectMapper(oldSubject, newSubject);
	}

	public void putSubjectMapper(SubjectKeyDto oldSubject, SubjectKeyDto newSubject) {
		AssertUtil.assertMethodRequire(oldSubject, "oldSubject");
		AssertUtil.assertMethodRequire(newSubject, "newSubject");
		mapper.put(oldSubject.showKey(), newSubject);
	}

	public SubjectKeyDto getSubject(SubjectType subjectType, Integer subjectId) {
		return mapper.get(new SubjectKeyDto(subjectType, subjectId).showKey());
	}
	
	public List<SubjectKeyDto> getSubjects(){
		return new ArrayList<>(mapper.values());
	}

}
