package com.mini.mshow.model.dbto.site;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;

import com.mini.framework.core.status.Status;
import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.framework.model.role.write.Insertable;
import com.mini.framework.model.role.write.Updatable;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.mshow.model.dbto.able.HaveAuthor;
import com.mini.mshow.model.dto.transfer.SubjectKeyDto;
import com.mini.mshow.model.type.SubjectType;

/**
 * 商城的banner
 * 
 * @author jayheo
 *
 */
public class MallBannerDbto extends DbtoIntEntity implements HaveAuthor {

	/**
	 * 
	 */
	private static final long serialVersionUID = -531963381846459405L;

	/**
	 * 标题
	 */
	@Insertable(require = "banner标题", minLength = 2, maxLength = 100)
	@Updatable(suffice = "banner标题", minLength = 2, maxLength = 100)
	private String title;

	/**
	 * 对应的主题id
	 */
	@Insertable(require = "banner跳转主题id")
	@Updatable(suffice = "banner跳转主题id")
	private Integer subjectId;

	/**
	 * 对应的跳转主题类型
	 */
	@Insertable(require = "banner跳转主题类型")
	@Updatable(suffice = "banner跳转主题类型")
	private SubjectType subjectType;

	/**
	 * 封面的图片资源
	 */
	@Insertable(require = "banner的封面")
	@Updatable(suffice = "banner的封面")
	private String coverResourse;

	/**
	 * 冗余作者id，方便后面统计
	 */
	@Insertable(require = "banner作者")
	@Updatable(forbid = "banner作者")
	private Integer authorId;

	@Insertable(require = "banner顺序")
	@Updatable(suffice = "banner顺序")
	private Double sorter;

	@Updatable(suffice = "使用状态")
	@Insertable(require = "使用状态")
	private Boolean useStatus;

	@Updatable(suffice = "删除状态")
	@Insertable(require = "删除状态")
	private Boolean deprecated;

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public Integer getSubjectId() {
		return subjectId;
	}

	public void setSubjectId(Integer subjectId) {
		this.subjectId = subjectId;
	}

	public SubjectType getSubjectType() {
		return subjectType;
	}

	public void setSubjectType(SubjectType subjectType) {
		this.subjectType = subjectType;
	}

	public String getCoverResourse() {
		return coverResourse;
	}

	public void setCoverResourse(String coverResourse) {
		this.coverResourse = coverResourse;
	}

	public Integer getAuthorId() {
		return authorId;
	}

	public void setAuthorId(Integer authorId) {
		this.authorId = authorId;
	}

	public Double getSorter() {
		return sorter;
	}

	public void setSorter(Double sorter) {
		this.sorter = sorter;
	}

	public Boolean getUseStatus() {
		return useStatus;
	}

	public void setUseStatus(Boolean useStatus) {
		this.useStatus = useStatus;
	}

	public Boolean getDeprecated() {
		return deprecated;
	}

	public void setDeprecated(Boolean deprecated) {
		this.deprecated = deprecated;
	}

	public SubjectKeyDto showSubjectKey() {
		return new SubjectKeyDto(subjectType, subjectId);
	}

	@Override
	public Integer showAuthorId() {
		return this.authorId;
	}

	public void initBasic() {
		deprecated = false;
		useStatus = true;
	}

	public boolean validateCoverResourse(Optional<Predicate<String>> validateUrlOptional, boolean ignoreAssert) {
		AssertUtil.assertMethodRequire(validateUrlOptional, "validateUrlOptional");
		boolean match = coverResourse != null && coverResourse.length() > 0;
		AssertUtil.assertNoBadReq(ignoreAssert || match, Status.BadReq.noReq, "banner封面coverResourse:[%s]不能为空",
				coverResourse);
		if (!ignoreAssert && validateUrlOptional.isPresent()) {
			match &= validateUrlOptional.get().test(coverResourse);
		}
		;
		AssertUtil.assertNoBadReq(ignoreAssert || match, Status.BadReq.illParam, "banner封面coverResourse:[%s]必须能访问",
				coverResourse);
		return match;
	}
	
	public Optional<SubjectOverviewDbto> validateIfSubjectKeyHaveOveriview(BiFunction<SubjectType,Integer, SubjectOverviewDbto> overviewGetter){
		AssertUtil.assertNoBadReq((subjectType!=null)== (subjectId!=null)
				, Status.BadReq.noReq, "banner跳转主题类型:[%s]和id:[%s]必须成对出现",subjectType,subjectId);
		if(subjectType!=null){
			return Optional.ofNullable(overviewGetter.apply(subjectType, subjectId));
		}else{
			return Optional.empty();
		}
		
	}
}
