package com.mini.mshow.model.dbto.site;

import java.util.List;
import java.util.function.BiFunction;

import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.mshow.model.dbto.able.HaveBanners;

/**
 * 用户的商城的展位的配置
 * @author jayheo
 *
 */
public class UserMallBoothDbto extends DbtoIntEntity implements HaveBanners{

	/**
	 * 
	 */
	private static final long serialVersionUID = 7706240881941093513L;
	
	private Integer userId;

	/**
	 * 要展示的bannerIds;
	 * MallBannerDbto
	 */
	private String bannerIds;

	/**
	 * 需要展示的商品id
	 * SubjectGoodsDbto
	 */
	private String goodsIds;

	public String getBannerIds() {
		return bannerIds;
	}

	public void setBannerIds(String bannerIds) {
		this.bannerIds = bannerIds;
	}

	public String getGoodsIds() {
		return goodsIds;
	}

	public void setGoodsIds(String goodsIds) {
		this.goodsIds = goodsIds;
	}
	
	public Integer getUserId() {
		return userId;
	}

	public void setUserId(Integer userId) {
		this.userId = userId;
	}

	@Override
	public List<Integer> showBannerIds() {
		return showBannerIds(this.bannerIds, parseIdFn);
	}

	public List<Integer> showBannerIds(BiFunction<String, String, Integer> parseIdFn){
		return showBannerIds(this.bannerIds, parseIdFn);
	}

}
