/*
 * Decompiled with CFR 0.152.
 */
package com.mini.mshow.model.dbto.site;

import com.mini.framework.core.exception.standard.UnsupportedException;
import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.framework.model.role.write.Insertable;
import com.mini.framework.model.role.write.Updatable;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.mshow.model.dbto.able.SupportBrowseStatistics;
import com.mini.mshow.model.dbto.able.SupportBuyStatistics;
import com.mini.mshow.model.dbto.able.SupportCollectStatistics;
import com.mini.mshow.model.dbto.able.SupportShareStatistics;
import com.mini.mshow.model.type.SubjectInteractType;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SubjectGoodsStatisticsDbto
extends DbtoIntEntity
implements SupportBrowseStatistics,
SupportShareStatistics,
SupportCollectStatistics,
SupportBuyStatistics {
    private static final long serialVersionUID = 595493963351390289L;
    @Insertable(require="\u5546\u54c1id")
    @Updatable(forbid="\u5546\u54c1id")
    private Integer goodsId;
    @Insertable(require="\u5546\u54c1\u4f5c\u8005")
    @Updatable(forbid="\u5546\u54c1\u4f5c\u8005")
    private Integer authorId;
    @Insertable(require="\u88ab\u8d2d\u4e70\u6570")
    @Updatable(suffice="\u88ab\u8d2d\u4e70\u6570")
    private Integer buyNum;
    @Insertable(require="\u88ab\u6d4f\u89c8\u6570")
    @Updatable(suffice="\u88ab\u6d4f\u89c8\u6570")
    private Integer browsedNum;
    @Insertable(require="\u88ab\u5206\u4eab\u6570")
    @Updatable(suffice="\u88ab\u5206\u4eab\u6570")
    private Integer sharedNum;
    @Insertable(require="\u88ab\u6536\u85cf\u6570")
    @Updatable(suffice="\u88ab\u6536\u85cf\u6570")
    private Integer collectedNum;
    @Insertable(require="\u603b\u88ab\u6536\u85cf\u6570")
    @Updatable(suffice="\u603b\u88ab\u6536\u85cf\u6570")
    private Integer allCollectedNum;
    @Insertable(require="\u88ab\u53d6\u6d88\u6536\u85cf\u6570")
    @Updatable(suffice="\u88ab\u53d6\u6d88\u6536\u85cf\u6570")
    private Integer cancelCollectedNum;

    @Override
    public Integer getBuyNum() {
        return this.buyNum;
    }

    @Override
    public void setBuyNum(Integer buyNum) {
        this.buyNum = buyNum;
    }

    @Override
    public Integer getBrowsedNum() {
        return this.browsedNum;
    }

    @Override
    public void setBrowsedNum(Integer browsedNum) {
        this.browsedNum = browsedNum;
    }

    @Override
    public Integer getSharedNum() {
        return this.sharedNum;
    }

    @Override
    public void setSharedNum(Integer sharedNum) {
        this.sharedNum = sharedNum;
    }

    @Override
    public Integer getCollectedNum() {
        return this.collectedNum;
    }

    @Override
    public void setCollectedNum(Integer collectedNum) {
        this.collectedNum = collectedNum;
    }

    @Override
    public Integer getAllCollectedNum() {
        return this.allCollectedNum;
    }

    @Override
    public void setAllCollectedNum(Integer allCollectedNum) {
        this.allCollectedNum = allCollectedNum;
    }

    @Override
    public Integer getCancelCollectedNum() {
        return this.cancelCollectedNum;
    }

    @Override
    public void setCancelCollectedNum(Integer cancelCollectedNum) {
        this.cancelCollectedNum = cancelCollectedNum;
    }

    public Integer getGoodsId() {
        return this.goodsId;
    }

    public void setGoodsId(Integer goodsId) {
        this.goodsId = goodsId;
    }

    public Integer getAuthorId() {
        return this.authorId;
    }

    public void setAuthorId(Integer authorId) {
        this.authorId = authorId;
    }

    public static SubjectGoodsStatisticsDbto createInit(Integer goodsId, Integer authorId) {
        SubjectGoodsStatisticsDbto init = new SubjectGoodsStatisticsDbto();
        init.goodsId = goodsId;
        init.authorId = authorId;
        return init.initNum();
    }

    public SubjectGoodsStatisticsDbto initNum() {
        this.buyNum = 0;
        this.collectedNum = 0;
        this.allCollectedNum = 0;
        this.cancelCollectedNum = 0;
        this.browsedNum = 0;
        this.sharedNum = 0;
        return this;
    }

    public int showStatisticsNum(SubjectInteractType interactType) {
        switch (interactType) {
            case browse: {
                return this.browsedNum;
            }
            case share: {
                return this.sharedNum;
            }
            case collect: {
                return this.collectedNum;
            }
        }
        throw new UnsupportedException("\u76f8\u518c\u6682\u65f6\u4e0d\u662f\u652f\u6301%s\u7684\u589e\u91cf", new Object[]{interactType});
    }

    public static boolean supportStatistics(SubjectInteractType interactType) {
        AssertUtil.assertMethodRequire((Object)((Object)interactType), (String)"interactType");
        return Stream.of(SubjectInteractType.browse, SubjectInteractType.share, SubjectInteractType.collect).collect(Collectors.toSet()).contains((Object)interactType);
    }

    public static SubjectGoodsStatisticsDbto createAtomByInteract(SubjectInteractType interactType, boolean cancel) {
        AssertUtil.assertMethodRequire((Object)((Object)interactType), (String)"interactType");
        SubjectGoodsStatisticsDbto atom = new SubjectGoodsStatisticsDbto();
        switch (interactType) {
            case browse: {
                atom.atomIncreaseBrowse();
                break;
            }
            case share: {
                atom.atomIncreaseShare();
                break;
            }
            case collect: {
                atom.atomSwitchCollect(cancel);
                break;
            }
            default: {
                throw new UnsupportedException("\u5546\u54c1\u6682\u65f6\u4e0d\u662f\u652f\u6301%s\u7684\u589e\u91cf", new Object[]{interactType});
            }
        }
        return atom;
    }
}

