/*
 * Decompiled with CFR 0.152.
 */
package com.mini.mshow.model.dbto.site;

import com.mini.framework.core.status.Status;
import com.mini.framework.core.status.StatusCode;
import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.framework.model.role.write.Insertable;
import com.mini.framework.model.role.write.Updatable;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.asserts.JudgeUtil;
import com.mini.framework.util.asserts.Require;
import com.mini.mshow.model.dbto.able.HaveGoods;
import com.mini.mshow.model.dbto.able.HaveMultiContent;
import com.mini.mshow.model.dbto.able.IsOneSubject;
import com.mini.mshow.model.dbto.site.SubjectOverviewDbto;
import com.mini.mshow.model.dto.multi.MultiFactory;
import com.mini.mshow.model.type.SubjectType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class SubjectGoodsDbto
extends DbtoIntEntity
implements HaveGoods,
IsOneSubject,
HaveMultiContent {
    private static final long serialVersionUID = 6149160031081726843L;
    @Insertable(require="\u5546\u54c1\u6807\u9898", minLength=2, maxLength=100)
    @Updatable(suffice="\u5546\u54c1\u6807\u9898", minLength=2, maxLength=100)
    private String title;
    @Updatable(suffice="\u9009\u9879\u53c2\u6570")
    private String options;
    @Updatable(suffice="\u5b9e\u9645\u552e\u4ef7")
    private Integer salePrice;
    @Updatable(suffice="\u539f\u59cb\u4ef7\u683c")
    private Integer originalPrice;
    @Insertable(require="\u6d3b\u52a8\u591a\u5a92\u4f53")
    @Updatable(suffice="\u6d3b\u52a8\u591a\u5a92\u4f53")
    private String multiContent;
    @Insertable(require="\u5546\u54c1\u7684\u62e5\u6709\u8005")
    @Updatable(forbid="\u5546\u54c1\u7684\u62e5\u6709\u8005")
    private Integer authorId;
    @Updatable(suffice="\u5c01\u9762")
    @Insertable(require="\u5c01\u9762")
    private String cover;
    @Updatable(suffice="\u7f6e\u9876")
    private Boolean topShow;
    @Updatable(suffice="\u7f6e\u9876\u6392\u5e8f\u5668")
    private Double topShowSorter;
    @Updatable(suffice="\u6392\u5e8f\u4f9d\u636e")
    @Insertable(require="\u6392\u5e8f\u4f9d\u636e")
    private Double sorter;
    @Updatable(suffice="\u8f6e\u64ad\u56fe")
    @Insertable(require="\u8f6e\u64ad\u56fe")
    private String covers;
    @Updatable(suffice="\u4f7f\u7528\u72b6\u6001")
    @Insertable(require="\u4f7f\u7528\u72b6\u6001")
    private Boolean useStatus;

    public SubjectOverviewDbto tryFindOverview() {
        boolean right = MultiFactory.validate(this.multiContent);
        SubjectOverviewDbto overview = null;
        overview = right ? SubjectOverviewDbto.findOverview(MultiFactory.fromJson(this.multiContent), 200) : new SubjectOverviewDbto();
        List<String> coverPhones = new ArrayList<String>(Arrays.asList(this.covers.split(",")));
        Collections.reverse(coverPhones);
        coverPhones.add(this.cover);
        coverPhones = coverPhones.stream().distinct().filter(Objects::nonNull).collect(Collectors.toList());
        for (String coverPhone : coverPhones) {
            overview.onImportantPhotoFound(Optional.ofNullable(coverPhone));
        }
        overview.setTitle(this.title);
        return overview.fillSubjectField(this);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getMultiContent() {
        return this.multiContent;
    }

    @Override
    public void setMultiContent(String multiContent) {
        this.multiContent = multiContent;
    }

    public String getCover() {
        return this.cover;
    }

    public void setCover(String cover) {
        this.cover = cover;
    }

    public Boolean getUseStatus() {
        return this.useStatus;
    }

    public void setCovers(String covers) {
        this.covers = covers;
    }

    public void setUseStatus(Boolean useStatus) {
        this.useStatus = useStatus;
    }

    public String getCovers() {
        return this.covers;
    }

    public Boolean getTopShow() {
        return this.topShow;
    }

    public void setTopShow(Boolean topShow) {
        this.topShow = topShow;
    }

    public Double getTopShowSorter() {
        return this.topShowSorter;
    }

    public void setTopShowSorter(Double topShowSorter) {
        this.topShowSorter = topShowSorter;
    }

    public Double getSorter() {
        return this.sorter;
    }

    public void setSorter(Double sorter) {
        this.sorter = sorter;
    }

    public Integer getSalePrice() {
        return this.salePrice;
    }

    public void setSalePrice(Integer salePrice) {
        this.salePrice = salePrice;
    }

    public Integer getOriginalPrice() {
        return this.originalPrice;
    }

    public void setOriginalPrice(Integer originalPrice) {
        this.originalPrice = originalPrice;
    }

    public Integer getAuthorId() {
        return this.authorId;
    }

    public void setAuthorId(Integer authorId) {
        this.authorId = authorId;
    }

    public String getOptions() {
        return this.options;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    @Override
    public SubjectType showSubectType() {
        return SubjectType.goods;
    }

    @Override
    public Integer showSubjectId() {
        return this.getId();
    }

    public SubjectGoodsDbto skipMulti() {
        this.setMultiContent(null);
        return this;
    }

    public SubjectGoodsDbto copy() {
        SubjectGoodsDbto copyActivity = new SubjectGoodsDbto();
        copyActivity.setTitle(this.getTitle());
        copyActivity.setMultiContent(this.getMultiContent());
        copyActivity.setCover(this.getCover());
        return copyActivity;
    }

    public boolean ifTopShowParams() {
        return this.topShow != null || this.topShowSorter != null;
    }

    @Override
    public Integer showGoodsId() {
        return this.getId();
    }

    @Override
    public Integer showAuthorId() {
        return this.authorId;
    }

    public boolean validatePrice(boolean ignoreAssert) {
        boolean match = this.originalPrice == null || this.salePrice == null || this.originalPrice >= this.salePrice;
        AssertUtil.assertNoBadReq((ignoreAssert || match ? 1 : 0) != 0, (StatusCode)Status.BadReq.illParam, (String)"\u539f\u4ef7originalPrice:[%s]\u4e0d\u80fd\u5c0f\u4e8e\u552e\u4ef7salePrice:[%s]", (Object[])new Object[]{this.originalPrice, this.salePrice});
        match &= this.originalPrice == null || this.originalPrice >= 0;
        AssertUtil.assertNoBadReq((ignoreAssert || (match &= this.salePrice == null || this.salePrice >= 0) ? 1 : 0) != 0, (StatusCode)Status.BadReq.illParam, (String)"\u539f\u4ef7originalPrice:[%s]\u548csalePrice:[%s]\u90fd\u4e0d\u80fd\u5c0f\u4e8e0", (Object[])new Object[]{this.originalPrice, this.salePrice});
        return match;
    }

    public boolean validateCover(Optional<Predicate<String>> validateUrlOptional, boolean ignoreAssert) {
        AssertUtil.assertMethodRequire(validateUrlOptional, (String)"validateUrlOptional");
        boolean match = this.cover != null && this.cover.length() > 0;
        AssertUtil.assertNoBadReq((ignoreAssert || match ? 1 : 0) != 0, (StatusCode)Status.BadReq.noReq, (String)"\u5c01\u9762cover:[%s]\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{this.cover});
        if (!ignoreAssert && validateUrlOptional.isPresent()) {
            match &= validateUrlOptional.get().test(this.cover);
        }
        AssertUtil.assertNoBadReq((ignoreAssert || match ? 1 : 0) != 0, (StatusCode)Status.BadReq.illParam, (String)"\u5c01\u9762cover:[%s]\u5fc5\u987b\u80fd\u8bbf\u95ee", (Object[])new Object[]{this.cover});
        AssertUtil.assertNoBadReq((ignoreAssert || (match &= this.covers != null) ? 1 : 0) != 0, (StatusCode)Status.BadReq.noReq, (String)"covers\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        AssertUtil.assertNoBadReq((ignoreAssert || (match &= JudgeUtil.match((Object)this.covers.split(",").length, (Require)Require.between, (Object[])new Object[]{1, 11})) ? 1 : 0) != 0, (StatusCode)Status.BadReq.illParam, (String)"covers\u4e2a\u6570\u5fc5\u987b\u4ecb\u4e8e[0,10]", (Object[])new Object[0]);
        if (!ignoreAssert && validateUrlOptional.isPresent()) {
            String[] stringArray = this.covers.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String c = stringArray[n2];
                AssertUtil.assertNoBadReq((ignoreAssert || (match &= validateUrlOptional.get().test(c)) ? 1 : 0) != 0, (StatusCode)Status.BadReq.illParam, (String)"\u8f6e\u64ad\u56fe[%s]\u5fc5\u987b\u80fd\u8bbf\u95ee", (Object[])new Object[]{c});
                ++n2;
            }
        }
        return match;
    }
}

