/*
 * Decompiled with CFR 0.152.
 */
package com.mini.mshow.model.dbto.site;

import com.mini.framework.model.dbto.style1.DbtoIntEntity;
import com.mini.framework.model.role.write.Insertable;
import com.mini.framework.model.role.write.Updatable;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.mshow.model.dbto.able.HaveAuthor;
import com.mini.mshow.model.dbto.able.IsOneSubject;
import com.mini.mshow.model.dto.multi.Content;
import com.mini.mshow.model.dto.multi.MultiContent;
import com.mini.mshow.model.dto.multi.MultiContentType;
import com.mini.mshow.model.dto.multi.PhotoContent;
import com.mini.mshow.model.dto.multi.VideoContent;
import com.mini.mshow.model.dto.multi.WordsContent;
import com.mini.mshow.model.type.SubjectType;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class SubjectOverviewDbto
extends DbtoIntEntity
implements HaveAuthor {
    private static final long serialVersionUID = 8942830178819272948L;
    private Map<String, String> fieldDesces = this.createFieldDesces();
    @Insertable(require="\u4e92\u52a8\u4e3b\u9898id")
    @Updatable(forbid="\u4e92\u52a8\u4e3b\u9898id")
    private Integer subjectId;
    @Insertable(require="\u4e92\u52a8\u4e3b\u9898\u7c7b\u578b")
    @Updatable(forbid="\u4e92\u52a8\u4e3b\u9898\u7c7b\u578b")
    private SubjectType subjectType;
    @Insertable(require="\u4e3b\u9898\u4f5c\u8005id")
    @Updatable(forbid="\u4e3b\u9898\u4f5c\u8005id")
    private Integer subjectAuthorId;
    @Insertable(require="\u6807\u9898")
    @Updatable(suffice="\u6807\u9898")
    private String title;
    @Updatable(suffice="\u5b50\u6807\u9898", maxLength=200)
    private String subTitle;
    @Insertable(require="\u5220\u9664\u7684\u72b6\u6001")
    @Updatable(suffice="\u5220\u9664\u7684\u72b6\u6001")
    private Boolean delStatus;
    @Updatable(suffice="\u7b2c\u4e00\u5f20\u56fe\u7247")
    private String firstPhoto;
    @Updatable(suffice="\u7b2c\u4e8c\u5f20\u56fe\u7247")
    private String secondPhoto;
    @Updatable(suffice="\u7b2c\u4e09\u5f20\u56fe\u7247")
    private String thirdlyPhoto;
    @Updatable(suffice="\u89c6\u9891\u5730\u5740")
    private String videoUrl;
    @Updatable(suffice="\u89c6\u9891\u5c01\u9762\u5730\u5740")
    private String videoCoverUrl;

    public static SubjectOverviewDbto findOverview(MultiContent multiContent, int maxWords) {
        AssertUtil.assertMethodRequire((Object)multiContent, (String)"multiContent");
        List<Content> contents = multiContent.getContents();
        SubjectOverviewDbto subjectOverviewDbto = new SubjectOverviewDbto();
        if (contents != null) {
            contents.stream().sorted().forEach(content -> {
                MultiContentType type = content.getType();
                switch (type) {
                    case photo: {
                        PhotoContent photo = (PhotoContent)content.takeContent();
                        subjectOverviewDbto.onPhotoFound(photo.getResourse());
                        break;
                    }
                    case words: {
                        if (subjectOverviewDbto.subTitle != null) break;
                        WordsContent words = (WordsContent)content.takeContent();
                        subjectOverviewDbto.subTitle = StringUtils.abbreviate((String)words.getWords(), (int)maxWords);
                        break;
                    }
                    case video: {
                        VideoContent video = (VideoContent)content.takeContent();
                        if (video.getCover() != null) {
                            subjectOverviewDbto.onPhotoFound(video.getCover());
                        }
                        if (subjectOverviewDbto.videoCoverUrl != null) break;
                        subjectOverviewDbto.videoCoverUrl = video.getCover();
                        subjectOverviewDbto.videoUrl = video.getSourse();
                        break;
                    }
                }
            });
        }
        return subjectOverviewDbto;
    }

    private int onPhotoFound(String photo) {
        AssertUtil.assertMethodRequire((Object)photo, (String)"photo");
        if (this.firstPhoto == null) {
            this.firstPhoto = photo;
            return 1;
        }
        if (this.secondPhoto == null) {
            this.secondPhoto = photo;
            return 2;
        }
        if (this.thirdlyPhoto == null) {
            this.thirdlyPhoto = photo;
            return 3;
        }
        return 0;
    }

    public SubjectOverviewDbto onImportantPhotoFound(Optional<String> importantPhoto) {
        AssertUtil.assertMethodRequire(importantPhoto, (String)"importantPhoto");
        if (importantPhoto.isPresent()) {
            if (this.secondPhoto != null) {
                this.thirdlyPhoto = this.secondPhoto;
            }
            if (this.firstPhoto != null) {
                this.secondPhoto = this.firstPhoto;
            }
            this.firstPhoto = importantPhoto.get();
        }
        return this;
    }

    public SubjectOverviewDbto fillTopPhoto(String ... photos) {
        String[] stringArray = photos;
        int n = photos.length;
        int n2 = 0;
        while (n2 < n) {
            String photo = stringArray[n2];
            this.onPhotoFound(photo);
            ++n2;
        }
        return this;
    }

    public SubjectOverviewDbto fillSubjectField(IsOneSubject subject) {
        this.setSubjectAuthorId(subject.showAuthorId());
        this.setSubjectId(subject.showSubjectId());
        this.setSubjectType(subject.showSubectType());
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    private Map<String, String> createFieldDesces() {
        LinkedHashMap<String, String> desces = new LinkedHashMap<String, String>();
        desces.put("\u8bf4\u660e1\uff0c\u663e\u793a\u6807\u9898\u548c\u4e00\u7167\u7247", "\u5224\u65adfirstPhoto\u5b58\u5728\u4e14secondPhoto\u4e0d\u5b58\u5728\u65f6\u4f7f\u7528");
        desces.put("\u8bf4\u660e2\uff0c\u663e\u793a\u6807\u9898\u548c\u4e8c\u7167\u7247", "\u5224\u65adfirstPhoto\u5b58\u5728\u4e14secondPhoto\u5b58\u5728\u4e14thirdlyPhoto\u4e0d\u5b58\u5728\u65f6\u4f7f\u7528");
        desces.put("\u8bf4\u660e3\uff0c\u663e\u793a\u6807\u9898\u548c\u4e09\u7167\u7247", "\u5224\u65adfirstPhoto\u5b58\u5728\u4e14secondPhoto\u5b58\u5728\u4e14thirdlyPhoto\u5b58\u5728\u65f6\u4f7f\u7528");
        desces.put("\u8bf4\u660e4\uff0c\u663e\u793a\u6807\u9898\u548c\u5b50\u6807\u9898", "\u5224\u65ad\u5b58\u5728\u4e14subTitle\u5b58\u5728\u65f6\u4f7f\u7528");
        desces.put("\u8bf4\u660e5\uff0c\u663e\u793a\u6807\u9898\u548c\u89c6\u9891", "\u5224\u65advideoUrl\u5b58\u5728\u4e14coverUrl\u5b58\u5728\u65f6\u4f7f\u7528");
        desces.put("\u8bf4\u660e6\uff0c\u5176\u5b83\u60c5\u51b5", "\u5f02\u5e38\u4e00\u5b9a\u8981\u628a\u8fd9\u4e2a\u6253\u5370\u51fa\u6765\uff0c\u6682\u65f6\u663e\u793a\u6807\u9898");
        desces.put("\u8bf4\u660e7\uff0c\u662f\u5426\u5b58\u5728\u88ab\u5220\u9664\u4e86?", "delStatus\u8868\u793a\u662f\u4e0d\u662f\u5220\u9664true\u8868\u793a\u5df2\u5220\u9664\uff0cfalse\u8868\u793a\u5b58\u5728\u6ca1\u6709\u5220\u9664\uff0c\u5982\u679c\u88ab\u5220\u9664\u4e86");
        return desces;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSubTitle() {
        return this.subTitle;
    }

    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }

    public String getFirstPhoto() {
        return this.firstPhoto;
    }

    public void setFirstPhoto(String firstPhoto) {
        this.firstPhoto = firstPhoto;
    }

    public String getSecondPhoto() {
        return this.secondPhoto;
    }

    public void setSecondPhoto(String secondPhoto) {
        this.secondPhoto = secondPhoto;
    }

    public String getThirdlyPhoto() {
        return this.thirdlyPhoto;
    }

    public void setThirdlyPhoto(String thirdlyPhoto) {
        this.thirdlyPhoto = thirdlyPhoto;
    }

    public String getVideoUrl() {
        return this.videoUrl;
    }

    public void setVideoUrl(String videoUrl) {
        this.videoUrl = videoUrl;
    }

    public Integer getSubjectId() {
        return this.subjectId;
    }

    public void setSubjectId(Integer subjectId) {
        this.subjectId = subjectId;
    }

    public SubjectType getSubjectType() {
        return this.subjectType;
    }

    public void setSubjectType(SubjectType subjectType) {
        this.subjectType = subjectType;
    }

    public Integer getSubjectAuthorId() {
        return this.subjectAuthorId;
    }

    public void setSubjectAuthorId(Integer subjectAuthorId) {
        this.subjectAuthorId = subjectAuthorId;
    }

    public String getVideoCoverUrl() {
        return this.videoCoverUrl;
    }

    public void setVideoCoverUrl(String videoCoverUrl) {
        this.videoCoverUrl = videoCoverUrl;
    }

    public void setFieldDesces(Map<String, String> fieldDesces) {
        this.fieldDesces = fieldDesces;
    }

    public Map<String, String> getFieldDesces() {
        return this.fieldDesces;
    }

    public Boolean getDelStatus() {
        return this.delStatus;
    }

    public void setDelStatus(Boolean delStatus) {
        this.delStatus = delStatus;
    }

    @Override
    public Integer showAuthorId() {
        return this.subjectAuthorId;
    }

    public boolean ifDelete() {
        return this.delStatus != null && this.delStatus != false;
    }
}

