package com.mini.framework.third.weixin.mapp.model;

import java.util.Optional;

import com.mini.framework.util.string.GsonUtil;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import com.google.gson.annotations.SerializedName;
import com.mini.framework.third.weixin.server.model.WeixinServerUserDetail;
import com.mini.framework.util.asserts.AssertUtil;

//{"errMsg":"getUserInfo:ok","rawData":"{\"nickName\":\"谢志豪\",\"gender\":1,\"language\":\"zh_CN\",\"city\":\"长沙\",\"province\":\"湖南\",\"country\":\"中国\",\"avatarUrl\":\"https://wx.qlogo.cn/mmopen/vi_32/DYAIOgq83epsJAzItHWl6NMxFUBYQMCzQB9XS8zjhEtNXT5Tsic8FG1tyAgkOmoKNCXNm2RYibRjNcI7K3PqI8Jg/132\"}","signature":"5f504719311628561f6333c71d2231fda0b31719","encryptedData":"x+M33hqcGw5GM1ilg/jmVw7C4KSNMDd51RLSoXxwG3w1CRsi5BVg3MHI3NijmE3Wtb0lbMNYQ124i034+P1M6x1n2pXoddAJx4u9NliGrIqkGhYCJSqbA3dp29gjMAx0xA7OLSRa53PK2pahiaKl+UkC+XqVlcygo+Z9G2XBS/gk4+kr1bX8QNbVbVDKouNho30tmMuedzZf1VzFa05FSu6WLe6yh8o5P+7surPM34QlOkTDMzt6tINxs/Ca1RS5tmz0LHz4MlfHQaMT/XTpkz52n1rEZu+ZQVEQwDFiqZ4UXvbOo56Ulez6qjvGD1arjQYVSyrY1t72p+1FuTU8XL5nXjl6Ue6OJMqU/3uGOKv1Vn8hVNf4kjZQfjz8Hn7sODXVxz+1rjc91jzo4ueBuLnBJ1xA4h7iQXiwMYI15IFk+Pv4InXRLulINVyLcbrS7AmO1bQHPyfR7sJtGnYvEogViSlrBuq5QQgahhX9w1hRNzUb3gb/DFfRHy72DlYHnZl1pbam5dMvxMiQVrLwZw==","iv":"Gx0GOGB7GelipWywFbi0Xg==","userInfo":{"nickName":"谢志豪","gender":1,"language":"zh_CN","city":"长沙","province":"湖南","country":"中国","avatarUrl":"https://wx.qlogo.cn/mmopen/vi_32/DYAIOgq83epsJAzItHWl6NMxFUBYQMCzQB9XS8zjhEtNXT5Tsic8FG1tyAgkOmoKNCXNm2RYibRjNcI7K3PqI8Jg/132"}}


/**
 * 小程序中拿到用户信息实体，可以参考以下文档<br>
 * https://developers.weixin.qq.com/miniprogram/dev/api/wx.getUserInfo.html
 * @author jayheo
 *
 */
public class MappUserInfoSecretResponse {

	/**
	 * 这个用户信息是前端传过来的隐藏了openid和unionid。
	 * 需要解密后才能得到，解密后的数据在cryptUserInfo中
	 */
	private MappUserInfoResponse userInfo;

	private MappUserInfoResponse cryptUserInfo;

	@SerializedName("errMsg")
	private String respMsg;

	@SerializedName("rawData")
	private String rawData;

	@SerializedName("signature")
	private String signature;

	@SerializedName("encryptedData")
	private String encryptedData;

	@SerializedName("iv")
	private String secretSession;

	public MappUserInfoResponse getUserInfo() {
		return userInfo;
	}

	public void setUserInfo(MappUserInfoResponse userInfo) {
		this.userInfo = userInfo;
	}

	public String getRespMsg() {
		return respMsg;
	}

	public void setRespMsg(String respMsg) {
		this.respMsg = respMsg;
	}

	public String getRawData() {
		return rawData;
	}

	public void setRawData(String rawData) {
		this.rawData = rawData;
	}

	public String getSignature() {
		return signature;
	}

	public void setSignature(String signature) {
		this.signature = signature;
	}

	public String getEncryptedData() {
		return encryptedData;
	}

	public void setEncryptedData(String encryptedData) {
		this.encryptedData = encryptedData;
	}

	public String getSecretSession() {
		return secretSession;
	}

	public void setSecretSession(String secretSession) {
		this.secretSession = secretSession;
	}
	
	public MappUserInfoResponse getCryptUserInfo() {
		return cryptUserInfo;
	}

	public void setCryptUserInfo(MappUserInfoResponse cryptUserInfo) {
		this.cryptUserInfo = cryptUserInfo;
	}
	
	public MappUserInfoResponse showUserInfoIfCrypt(){
		return cryptUserInfo!=null?cryptUserInfo: userInfo;
	}
	
	public Optional<String> showUnionid(){
		return Optional.ofNullable(showUserInfoIfCrypt()).map(MappUserInfoResponse::getUnionid);
	}
	
	public static  MappUserInfoSecretResponse fromJson(String userInfoJson){
		AssertUtil.assertMethodRequire(userInfoJson, "userInfoJson");
		return GsonUtil.fromJson(userInfoJson, MappUserInfoSecretResponse.class);
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.DEFAULT_STYLE);
	}
	
	public Optional<WeixinServerUserDetail> mapServerUserDetail(){
		MappUserInfoResponse userInfo = showUserInfoIfCrypt();
		return Optional.ofNullable(userInfo).map(MappUserInfoResponse::mapServerUserDetail);
	}

}
