package com.mini.framework.third.weixin.pay.client;

import java.util.Map;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

import com.mini.framework.util.string.XStreamUtil;
import com.thoughtworks.xstream.annotations.XStreamAlias;


/**
 * @Auther: yuyi
 * @Date: 2018/8/25 18:35
 * @Description: 同步返回参数
 */
@XStreamAlias("xml")
@Root(name = "xml", strict = false)
public class MappPrePayResponse extends ConnMessageResponse{


    @Element(name = "device_info", required = false)
    @XStreamAlias("device_info")
    private String deviceInfo;


    /** 以下字段在return_code 和result_code都为SUCCESS的时候有返回. */
    @Element(name = "trade_type", required = false)
    @XStreamAlias("trade_type")
    private String tradeType;

    @Element(name = "prepay_id", required = false)
    @XStreamAlias("prepay_id")
    private String prepayId;

    @Element(name = "code_url", required = false)
    @XStreamAlias("code_url")
    private String codeUrl;

    @Element(name = "mweb_url", required = false)
    @XStreamAlias("mweb_url")
    private String mwebUrl;
    /** 微信支付异步返回的数据. */

	public String getDeviceInfo() {
		return deviceInfo;
	}

	public void setDeviceInfo(String deviceInfo) {
		this.deviceInfo = deviceInfo;
	}

	public String getTradeType() {
		return tradeType;
	}

	public void setTradeType(String tradeType) {
		this.tradeType = tradeType;
	}

	public String getPrepayId() {
		return prepayId;
	}

	public void setPrepayId(String prepayId) {
		this.prepayId = prepayId;
	}

	public String getCodeUrl() {
		return codeUrl;
	}

	public void setCodeUrl(String codeUrl) {
		this.codeUrl = codeUrl;
	}

	public String getMwebUrl() {
		return mwebUrl;
	}

	public void setMwebUrl(String mwebUrl) {
		this.mwebUrl = mwebUrl;
	}
    
    @Override
    public String toString() {

		return ToStringBuilder.reflectionToString(this,ToStringStyle.SHORT_PREFIX_STYLE);
    }
    
    
    public Map<String, String> toMap(){
    	return XStreamUtil.beanToMap(this);
    }

	@Override
	public String messageType() {
		return "小程序预支付响应";
	}
}
