package com.mini.framework.third.weixin.pay.client;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import com.thoughtworks.xstream.annotations.XStreamAlias;


/**
 * 公众号支付前数据准备的请求
 * @author jayheo
 *
 */
@XStreamAlias("xml")
public class PublicRefundApplyRequest extends ConnMessageRequest implements MessageMd5Signable{

	/*
微信订单号	transaction_id	二选一	String(32)	1217752501201407033233368018	微信生成的订单号，在支付通知中有返回
商户订单号	out_trade_no	String(32)	1217752501201407033233368018	商户系统内部订单号，要求32个字符内，只能是数字、大小写字母_-|*@ ，且在同一个商户号下唯一。
transaction_id、out_trade_no二选一，如果同时存在优先级：transaction_id> out_trade_no
	 * */
	

    /**
     * transaction_id和outTradeNo只要一个
     * 站点程序提供的订单号
     */
    @XStreamAlias("out_trade_no")
    private String outTradeNo;
	
    /**
     * 商户退款单号	out_refund_no	是	String(64)	1217752501201407033233368018	商户系统内部的退款单号，商户系统内部唯一，只能是数字、大小写字母_-|*@ ，同一退款单号多次请求只退一笔。
     */
    @XStreamAlias("out_refund_no")
    private String outRefundNo;
    
    

    /**
     * 订单金额	total_fee	是	Int	100	订单总金额，单位为分，只能为整数，详见支付金额
     */
    @XStreamAlias("total_fee")
    private Integer totalFee;
    
    /**
     * 退款金额	refund_fee	是	Int	100	退款总金额，订单总金额，单位为分，只能为整数，详见支付金额
     */
    @XStreamAlias("refund_fee")
    private Integer refundFee;
    

    /**
     * 退款结果通知url	notify_url	否	String(256)	https://weixin.qq.com/notify/	
异步接收微信支付退款结果通知的回调地址，通知URL必须为外网可访问的url，不允许带参数

如果参数中传了notify_url，则商户平台上配置的回调地址将不会生效。
     */
    @XStreamAlias("notify_url")
    private String notifyUrl;

    
    
    public String getOutTradeNo() {
		return outTradeNo;
	}

	public void setOutTradeNo(String outTradeNo) {
		this.outTradeNo = outTradeNo;
	}

	public String getOutRefundNo() {
		return outRefundNo;
	}

	public void setOutRefundNo(String outRefundNo) {
		this.outRefundNo = outRefundNo;
	}

	public Integer getTotalFee() {
		return totalFee;
	}

	public void setTotalFee(Integer totalFee) {
		this.totalFee = totalFee;
	}

	public Integer getRefundFee() {
		return refundFee;
	}

	public void setRefundFee(Integer refundFee) {
		this.refundFee = refundFee;
	}

	public String getNotifyUrl() {
		return notifyUrl;
	}

	public void setNotifyUrl(String notifyUrl) {
		this.notifyUrl = notifyUrl;
	}

	public PublicRefundApplyRequest() {
		super();
	}

	@Override
    public String toString() {
		return ToStringBuilder.reflectionToString(this,ToStringStyle.SHORT_PREFIX_STYLE);
    }

	@Override
	public String messageType() {
		return "公众号退款请求";
	}
}
