package com.mini.framework.third.weixin.pay.model;

import java.util.stream.Stream;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.asserts.TypeSwitchAssert;
import com.mini.framework.util.log.Event5WBuilder;
import com.mini.framework.util.log.MiniLogLevel;

/**
 * @author jayheo
 * 支付状
 */
public enum PayStatusType implements TypeSwitchAssert{
	
	/**
	 * 在支付中
	 */
	paying(new String[]{"NOTPAY","USERPAYING","REVOKED"},new String[]{"success","fail"}),
	/**
	 * 支付成功
	 */
	success(new String[]{"SUCCESS","REFUND"},new String[]{}),
	/**
	 * 支付失败 
	 */
	fail(new String[]{"CLOSED","PAYERROR"},new String[]{});


	private static Logger logger = LogManager.getLogger(PayStatusType.class);
	private String[] maps;
	
	private String[] nexts;
	
	private PayStatusType(String[] maps,String[] nexts) {
		this.maps = maps;
		this.nexts = nexts;
	}
	/** <pre>
SUCCESS—支付成功
REFUND—转入退款
NOTPAY—未支付
CLOSED—已关闭
REVOKED—已撤销（刷卡支付）
USERPAYING--用户支付中
PAYERROR--支付失败(其他原因，如银行返回失败)
https://pay.weixin.qq.com/wiki/doc/api/jsapi.php?chapter=9_2
 </pre>
	 */
	public static PayStatusType weixinPublicStatus(String statusResp){
		AssertUtil.assertMethodRequire(statusResp, "statusResp");
		PayStatusType mapStatus = Stream.of(PayStatusType.values()).filter(status->{
			return Stream.of(status.maps).filter(map->map.equals(statusResp)).count()==1;
		}).findFirst().orElse(null);
		
		if(mapStatus ==null){
			Event5WBuilder event = Event5WBuilder.todo(5, "payStatus").what("需要快速映射微信支付状态").why("发现没有映射的微信支付状态码:[%s],已当作失败处理",statusResp)
			.when("在映射微信状态码").who("状态映射器");
			logger.log(MiniLogLevel.getKeyBizLog(), event);
			mapStatus = fail;
		}
		return mapStatus;
	}
	
	/**
	 * 在发起支付的状态默认设置一个状态
	 * 如果用户没有做什么操作以后就是这个状态了
	 * @return
	 */
	public static String getInitStatus(){ 
		return "USERPAYING";
	}
	@Override
	public String[] showNexts() {
		return nexts;
	}
	@Override
	public String showSelfName() {
		return name();
	}
}
