package com.mini.framework.third.weixin.server.comm;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.google.gson.annotations.SerializedName;

/**
 * openid列表
 * @author jayheo
 *
 */
public class OpenidListResponse extends AbstractResponse {

	/**
	 * 总数
	 */
	@SerializedName("total")
	private Integer total;

	/**
	 * 本次取到的数量
	 */
	@SerializedName("count")
	private Integer size;

	/**
	 * 分页的下一个起点
	 */
	@SerializedName("next_openid")
	private String nextOffset;

	/**
	 * 分页的下一个起点
	 */
	@SerializedName("data")
	private Map<String,List<String>> data;
	

	public Integer getTotal() {
		return total;
	}

	public void setTotal(Integer total) {
		this.total = total;
	}

	public Integer getSize() {
		return size;
	}

	public void setSize(Integer size) {
		this.size = size;
	}

	public String getNextOffset() {
		return nextOffset;
	}

	public void setNextOffset(String nextOffset) {
		this.nextOffset = nextOffset;
	}

	public Map<String, List<String>> getData() {
		return data;
	}

	public void setData(Map<String, List<String>> data) {
		this.data = data;
	}

	public List<String> getOpenids() {
		if(data!=null){
			if(data.get("openid")!=null){
				return data.get("openid");
			}
		}
		return new ArrayList<String>();
	}
	

}
