/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.aliyun;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.green.model.v20180509.ImageSyncScanRequest;
import com.aliyuncs.green.model.v20180509.TextScanRequest;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.HttpResponse;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.mini.framework.core.exception.ThirdException;
import com.mini.framework.core.status.Status;
import com.mini.framework.third.aliyun.model.content.ContentGreenPhotoResponse;
import com.mini.framework.third.aliyun.model.content.ContentGreenTextResponse;
import com.mini.framework.third.aliyun.model.content.SuggestionResult;
import com.mini.framework.third.aliyun.model.content.photo.PhotoScene;
import com.mini.framework.third.aliyun.model.content.text.TextScene;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.log.Event5WBuilder;
import com.mini.framework.util.string.StringUtil;
import com.mini.framework.util.string.gson.builder.GsonData;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ContentGreenHelper {
    private static Logger logger = LogManager.getLogger(ContentGreenHelper.class);
    private static int textMax = 5000;

    public static DefaultProfile createProfile(String accessKeyId, String secret) {
        return DefaultProfile.getProfile((String)"cn-shanghai", (String)accessKeyId, (String)secret);
    }

    public static Optional<SuggestionResult> simpleSingleTextAnalysis(IClientProfile profile, String content, TextScene[] scenes) {
        AssertUtil.assertMethodRequire((Object)content, (String)"content");
        if (content.length() > textMax) {
            HashSet<String> contents = new HashSet<String>();
            while (content.length() > textMax) {
                contents.add(content.substring(0, 5000));
                content = content.substring(5000);
            }
            return ContentGreenHelper.simpleTextAnalysis(profile, contents, scenes).showSeriousResult();
        }
        ContentGreenTextResponse resp = ContentGreenHelper.simpleTextAnalysis(profile, Stream.of(content).collect(Collectors.toSet()), scenes);
        return resp.showSeriousResult();
    }

    public static ContentGreenTextResponse simpleTextAnalysis(IClientProfile profile, Set<String> contents, TextScene[] scenes) {
        String reqBody = GsonData.build().param("scenes", (Object)scenes).array("tasks", array -> {
            for (String content : contents) {
                AssertUtil.assertSupport((content != null ? 1 : 0) != 0, (String)"\u5185\u5bb9\u4e2d\u4e0d\u5141\u8bb8\u4f7f\u7528\u7a7a\u6307\u9488", (Object[])new Object[0]);
                array.add(GsonData.build().param("dataId", DigestUtils.md5Hex((String)content)).param("content", content));
            }
        }).toJson();
        Event5WBuilder event = Event5WBuilder.event((int)1, (Object)"ContentGreen-simpleTextAnalysis").what("\u68c0\u67e5\u6587\u672c\u8bf7\u6c42reqJson:[%s]", new Object[]{reqBody});
        String respJson = ContentGreenHelper.requestJson(profile, new TextScanRequest(), reqBody, 3000, 60000);
        event.result("\u5f97\u5230\u7ed3\u679crespJson:[%s]", new Object[]{respJson});
        logger.debug(event.create());
        ContentGreenTextResponse respBean = ContentGreenTextResponse.fromJson(ContentGreenTextResponse.class, respJson);
        return respBean;
    }

    public static Optional<SuggestionResult> simpleSinglePhotoAnalysis(IClientProfile profile, String url, PhotoScene[] scenes) {
        AssertUtil.assertMethodRequire((Object)url, (String)"url");
        ContentGreenPhotoResponse resp = ContentGreenHelper.simplePhotoAnalysis(profile, Stream.of(url).collect(Collectors.toSet()), scenes);
        return resp.showResultByUrl(url);
    }

    public static ContentGreenPhotoResponse simplePhotoAnalysis(IClientProfile profile, Set<String> urls, PhotoScene[] scenes) {
        String reqBody = GsonData.build().param("scenes", (Object)scenes).array("tasks", array -> {
            for (String url : urls) {
                AssertUtil.assertSupport((url != null ? 1 : 0) != 0, (String)"url\u4e0d\u5141\u8bb8\u4f7f\u7528\u7a7a\u6307\u9488", (Object[])new Object[0]);
                array.add(GsonData.build().param("dataId", DigestUtils.md5Hex((String)url)).param("url", url));
            }
        }).toJson();
        Event5WBuilder event = Event5WBuilder.event((int)1, (Object)"ContentGreen-simplePhotoAnalysis").what("\u68c0\u67e5\u56fe\u7247\u8bf7\u6c42reqJson:[%s]", new Object[]{reqBody});
        String respJson = ContentGreenHelper.requestJson(profile, new ImageSyncScanRequest(), reqBody, 3000, 60000);
        event.result("\u5f97\u5230\u7ed3\u679crespJson:[%s]", new Object[]{respJson});
        logger.debug(event.create());
        ContentGreenPhotoResponse respBean = ContentGreenPhotoResponse.fromJson(ContentGreenPhotoResponse.class, respJson);
        return respBean;
    }

    public static String requestJson(IClientProfile profile, AcsRequest<?> textScanRequest, String jsonReqBody, int connectTimeout, int readTimeout) {
        DefaultAcsClient client = new DefaultAcsClient(profile);
        textScanRequest.setAcceptFormat(FormatType.JSON);
        textScanRequest.setHttpContentType(FormatType.JSON);
        textScanRequest.setMethod(MethodType.POST);
        textScanRequest.setEncoding("UTF-8");
        textScanRequest.setRegionId(profile.getRegionId());
        textScanRequest.setHttpContent(StringUtil.getUtf8Byte((String)jsonReqBody), "UTF-8", FormatType.JSON);
        textScanRequest.setConnectTimeout(Integer.valueOf(connectTimeout));
        textScanRequest.setReadTimeout(Integer.valueOf(readTimeout));
        textScanRequest.setProtocol(ProtocolType.HTTPS);
        try {
            HttpResponse textScanResponse = client.doAction(textScanRequest);
            if (!textScanResponse.isSuccess()) {
                throw new ThirdException(Status.Third.aliyunConnent, "\u53d1\u8d77\u5230\u963f\u91cc\u4e91\u7684\u8fde\u63a5\u51fa\u9519,status:%s", new Object[]{textScanResponse.getStatus()});
            }
            String respJson = textScanResponse.getHttpContentString();
            return respJson;
        }
        catch (ServerException e) {
            throw new ThirdException((Throwable)e, Status.Third.aliyunConnent, "\u53d1\u8d77\u5230\u963f\u91cc\u4e91\u7684\u8fde\u63a5\u51fa\u9519,\u670d\u52a1\u7aef\u9519\u8bef", new Object[0]);
        }
        catch (ClientException e) {
            throw new ThirdException((Throwable)e, Status.Third.aliyunConnent, "\u53d1\u8d77\u5230\u963f\u91cc\u4e91\u7684\u8fde\u63a5\u51fa\u9519,\u5ba2\u6237\u7aef\u9519\u8bef", new Object[0]);
        }
    }
}

