/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.kuaidi100;

import com.mini.framework.third.kuaidi100.model.ExpressStatusResponse;
import com.mini.framework.third.kuaidi100.model.StatusSubscribeResponse;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.http.SimpleHttpUtil;
import com.mini.framework.util.params.MapParams;
import com.mini.framework.util.string.gson.builder.GsonData;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;

public class Kuaidi100Client {
    private Kuaidi100Client() {
    }

    public static Kuaidi100Client build() {
        return new Kuaidi100Client();
    }

    public StatusSubscribeResponse createSubscribePoll(String accessKey, String company, String number, String callbackurl) {
        String url = "https://poll.kuaidi100.com/poll";
        AssertUtil.assertMethodRequire((Object)accessKey, (String)"accessKey");
        AssertUtil.assertMethodRequire((Object)company, (String)"company");
        AssertUtil.assertMethodRequire((Object)number, (String)"number");
        AssertUtil.assertMethodRequire((Object)callbackurl, (String)"callbackurl");
        String param = GsonData.build().param("company", company).param("number", number).param("key", accessKey).object("parameters", parameters -> parameters.param("callbackurl", callbackurl)).toJson();
        String result = SimpleHttpUtil.simpleGet((String)url, (Map)MapParams.build((String)"schema", (Object)"json").param("param", (Object)param).toStringMap());
        return StatusSubscribeResponse.fromJson(result);
    }

    public ExpressStatusResponse queryCurrentStatus(String customer, String accessKey, String company, String number) {
        String url = "https://poll.kuaidi100.com/poll/query.do";
        AssertUtil.assertMethodRequire((Object)customer, (String)"customer");
        AssertUtil.assertMethodRequire((Object)accessKey, (String)"accessKey");
        AssertUtil.assertMethodRequire((Object)company, (String)"company");
        AssertUtil.assertMethodRequire((Object)number, (String)"number");
        String param = GsonData.build().param("com", company).param("num", number).toJson();
        String sign = DigestUtils.md5Hex((String)(param + accessKey + customer)).toUpperCase();
        String result = SimpleHttpUtil.simpleGet((String)url, (Map)MapParams.build((String)"customer", (Object)customer).param("sign", (Object)sign).param("param", (Object)param).toStringMap());
        return ExpressStatusResponse.fromJson(result);
    }
}

