/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.lizhi.util;

import com.mini.framework.core.exception.BadReqException;
import com.mini.framework.core.exception.HandleIOException;
import com.mini.framework.core.status.Status;
import com.mini.framework.third.lizhi.model.TicketDto;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.log.Event5WBuilder;
import com.mini.framework.util.string.RegexUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TicketFactory {
    private static String ticketRegex = "([^,]*):([^,]*),([^,]*),([^,]*),([^,]*),([^,]*),([^,]*),([^,]*),(http[^,]*)";
    private static String[] fileCharsets = new String[]{"ISO_8859_1", "UTF-8", "US-ASCII", "GBK"};
    private static String[] rightFlag = new String[]{"\u7801", "\u4f18\u60e0", "\u91d1", "\u7528"};
    private static String channelPattern = "https://[^/]*weike[^/]*/channel[^/]*/(\\d+)?";
    private static Logger logger = LogManager.getLogger(TicketFactory.class);

    public static TicketDto readFromString(String line) {
        TicketDto ticket = new TicketDto();
        ticket.setLine(line);
        String[] matchs = RegexUtil.getMatch((String)ticketRegex, (String)line, (int[])new int[]{2, 3, 6, 8, 9});
        if (matchs != null) {
            ticket.setNumber(matchs[0]);
            try {
                ticket.setPrice(Double.parseDouble(matchs[1]));
            }
            catch (NumberFormatException e) {
                throw new BadReqException("\u65e0\u6cd5\u89e3\u6790\u4ef7\u683c:[%s],\u884c\u6570\u636e:[%s]", new Object[]{matchs[1], line});
            }
            ticket.setUseName(matchs[2]);
            ticket.setUserDate(null);
            String accessUrl = matchs[4];
            ticket.setAccessUrl(accessUrl);
            ticket.setTargetUrl(StringUtils.substringBefore((String)accessUrl, (String)"?"));
            String channel = TicketFactory.findChannelFromUrl(accessUrl);
            ticket.setChannel(channel);
            ticket.setVersion(1);
        }
        return ticket;
    }

    public static String findChannelFromUrl(String accessUrl) {
        String channel = RegexUtil.getMatch((String)channelPattern, (String)accessUrl, (int)1);
        return channel;
    }

    public static List<TicketDto> readFromString(File file) {
        List<String> lines = TicketFactory.readMatchFirstLines(file);
        return TicketFactory.readFromString(lines);
    }

    public static boolean matchTicketFirst(String line) {
        AssertUtil.assertMethodRequire((Object)line, (String)"line");
        return Stream.of(rightFlag).filter(flag -> line.contains((CharSequence)flag)).count() > 0L;
    }

    public static List<String> readMatchFirstLines(File file) {
        IOException ex = null;
        String charset = null;
        for (String fileCharset : fileCharsets) {
            List result = null;
            try {
                List tempResult = result = FileUtils.readLines((File)file, (String)fileCharset);
                Optional firstLineOptional = tempResult.stream().findFirst();
                if (firstLineOptional.isPresent()) {
                    String firstLine = (String)firstLineOptional.get();
                    result.subList(0, 1).clear();
                    boolean match = TicketFactory.matchTicketFirst(firstLine);
                    Event5WBuilder event = Event5WBuilder.event((int)1, (Object)"readMatchFirstLines").who("\u6587\u4ef6:[%s]", new Object[]{file}).what("\u5339\u914d\u8354\u679d\u89c4\u5219", new Object[0]).result("\u5339\u914d\u72b6\u6001\u4e3a:[%s]", new Object[]{match}).how("\u901a\u8fc7\u5b57\u7b26\u7f16\u7801:[%s]\u89e3\u6790\u68c0\u67e5\u9996\u884c\u6709\u6ca1\u6709\u5173\u952e\u5b57:[%s],\u9996\u9875\u5185\u5bb9\u662f:[%s]", new Object[]{fileCharset, String.join((CharSequence)",", rightFlag), firstLine});
                    logger.info((Object)event);
                    if (!match) {
                        continue;
                    }
                } else {
                    logger.debug("\u6587\u4ef6:[{}]\u4e2d\u8bfb\u53d6\u7684\u5185\u5bb9\u957f\u5ea6\u4e3a:0", (Object)file);
                }
            }
            catch (FileNotFoundException e) {
                throw new HandleIOException((Throwable)e, "\u8bfb\u5238\u5185\u5bb9\u65f6\u627e\u4e0d\u5230\u6587\u4ef6", new Object[0]);
            }
            catch (IOException e) {
                charset = fileCharset;
                ex = e;
                continue;
            }
            return result;
        }
        if (ex != null) {
            throw new HandleIOException((Throwable)ex, "\u7528\u7f16\u7801:[%s]\u8bfb\u53d6\u5b57\u7b26\u4e32\u5185\u5bb9\u65f6\u51fa\u9519", new Object[]{charset});
        }
        throw new BadReqException(Status.BadReq.illParam, "\u6587\u4ef6%s\u65e0\u6cd5\u89e3\u6790\u51fa\u6b63\u5e38\u7684\u4f18\u60e0\u5238\u9996\u884c\u5fc5\u987b\u5305\u542b\u5b57\u6837:[%s]\u7684\u4e00\u90e8\u5206", new Object[]{file, String.join((CharSequence)",", rightFlag)});
    }

    public static List<TicketDto> readFromString(List<String> lines) {
        List<TicketDto> tickets = lines.stream().filter(line -> StringUtils.isNotBlank((CharSequence)line)).map(line -> TicketFactory.readFromString(line)).collect(Collectors.toList());
        return tickets;
    }
}

