/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.resourse.article.block;

import com.mini.framework.core.exception.BusyException;
import com.mini.framework.core.status.Status;
import com.mini.framework.core.status.StatusCode;
import com.mini.framework.third.resourse.article.block.ResourseAnalysis;
import com.mini.framework.third.resourse.article.block.ResourseAnalysisType;
import com.mini.framework.third.resourse.article.block.model.ArticleRawContent;
import com.mini.framework.util.asserts.AssertUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class ReadArticleBlockHelper {
    private Map<String, ResourseAnalysis> analysises;

    public static ReadArticleBlockHelper simpleBuild() {
        ReadArticleBlockHelper ssh = new ReadArticleBlockHelper();
        ssh.analysises = ReadArticleBlockHelper.buildSimpleAnalysises();
        return ssh;
    }

    public static Map<String, ResourseAnalysis> buildSimpleAnalysises() {
        LinkedHashMap<String, ResourseAnalysis> analysises = new LinkedHashMap<String, ResourseAnalysis>();
        for (ResourseAnalysisType resourseAnalysisType : ResourseAnalysisType.values()) {
            try {
                analysises.put(resourseAnalysisType.name(), resourseAnalysisType.getAnalysisClass().newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new BusyException((Throwable)e, "\u5728\u521b\u5efa\u7c7b%s\u7684\u5b9e\u4f8b\u65f6\u62a5\u9519", new Object[]{resourseAnalysisType.getAnalysisClass()});
            }
        }
        return analysises;
    }

    public ArticleRawContent read(String url) {
        Optional<ResourseAnalysis> analysis = this.analysises.entrySet().stream().map(Map.Entry::getValue).filter(ass -> ass.urlResourseMatch(url)).findFirst();
        AssertUtil.assertNoBadReq((boolean)analysis.isPresent(), (StatusCode)Status.BadReq.illParam, (String)"\u7cfb\u7edf\u6682\u65f6\u6ca1\u6709\u80fd\u89e3\u6790:[%s]\u7684\u5de5\u5177\u7c7b", (Object[])new Object[]{url});
        return analysis.get().analysis(url);
    }
}

