/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.console.model;

import com.mini.framework.core.exception.BadReqException;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.params.MapParams;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class WeixinCurlCommand {
    private String url;
    private String cookie;

    public WeixinCurlCommand(String url, String cookie) {
        this.url = url;
        this.cookie = cookie;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getCookie() {
        return this.cookie;
    }

    public void setCookie(String cookie) {
        this.cookie = cookie;
    }

    public String getTokenParam() {
        return this.queryTokenParam().orElseThrow(() -> new BadReqException("command\u4e2d\u7684url:[%s]\u5fc5\u987b\u6709token\u53c2\u6570", new Object[]{this.url}));
    }

    public Optional<String> queryTokenParam() {
        return this.queryParam("token");
    }

    public WeixinCurlCommand setUrlIntParam(String name, int value) {
        return this.setUrlParam(name, value + "");
    }

    public WeixinCurlCommand setUrlParam(String name, String value) {
        AssertUtil.assertMethodRequire((Object)name, (String)"name");
        AssertUtil.assertMethodRequire((Object)value, (String)"value");
        Optional<String> paramOptional = this.queryParam(name);
        this.url = paramOptional.isPresent() ? this.url.replace(name + "=" + paramOptional.get(), name + "=" + value) : MapParams.build((String)name, (Object)value).toUrlParams(this.url);
        return this;
    }

    public Optional<String> queryParam(String name) {
        AssertUtil.assertMethodRequire((Object)this.url, (String)"url");
        for (String nv : StringUtils.substringAfter((String)this.url, (String)"?").split("&")) {
            if (!name.equals(nv.split("=")[0])) continue;
            return Optional.of(nv.split("=").length >= 2 ? nv.split("=")[1] : "");
        }
        return Optional.empty();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

