/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.mapp;

import com.mini.framework.core.exception.HandleException;
import com.mini.framework.third.weixin.mapp.model.AccessTokenResponse;
import com.mini.framework.third.weixin.mapp.model.MappCodePhotoRequest;
import com.mini.framework.third.weixin.mapp.model.SimpleAuthResponse;
import com.mini.framework.third.weixin.mapp.model.SimpleResponse;
import com.mini.framework.third.weixin.mapp.model.bean.SubscribeMessageParam;
import com.mini.framework.third.weixin.mapp.model.template.MessageTemplateLibraryResponse;
import com.mini.framework.third.weixin.mapp.model.template.MessageTemplateResponse;
import com.mini.framework.third.weixin.mapp.model.template.SiteMessageTemplatesResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;

public interface WeixinMappSdk {
    public static final String mappSdkPackage = "com.mini.framework.third.weixin.mapp";
    public static final ExecutorService executor = Executors.newCachedThreadPool();

    @GetMapping(value={"/sns/jscode2session?appid=%s&secret=%s&js_code=%s&grant_type=authorization_code"})
    public SimpleAuthResponse queryAuthByCode(String var1, String var2, String var3);

    @PostMapping(value={"/wxa/getwxacodeunlimit?access_token=%s"})
    public byte[] createMappQrcode(String var1, MappCodePhotoRequest var2);

    @GetMapping(value={"/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s"})
    public AccessTokenResponse createAccessToken(String var1, String var2);

    @PostMapping(value={"/cgi-bin/wxopen/template/library/list?access_token=%s"})
    public MessageTemplateLibraryResponse listWeixinMessageTemplates(String var1, int var2, int var3);

    default public MessageTemplateLibraryResponse listWeixinMessageTemplates(String accessToken, int offset, int limit, boolean detail) {
        if (!detail) {
            return this.listWeixinMessageTemplates(accessToken, offset, limit);
        }
        MessageTemplateLibraryResponse resp = this.listWeixinMessageTemplates(accessToken, offset, limit);
        List<MessageTemplateResponse> templates = resp.getTemplates();
        ArrayList<FutureTask<MessageTemplateResponse>> tasks = new ArrayList<FutureTask<MessageTemplateResponse>>();
        for (int i = 0; i < templates.size(); ++i) {
            String string = templates.get(i).getKey();
            FutureTask<MessageTemplateResponse> task = new FutureTask<MessageTemplateResponse>(() -> {
                MessageTemplateResponse tempDesc = this.getWeixinMessageTemplate(accessToken, key);
                return tempDesc;
            });
            executor.submit(task);
            tasks.add(task);
        }
        templates.clear();
        for (FutureTask futureTask : tasks) {
            try {
                MessageTemplateResponse tempDesc = (MessageTemplateResponse)futureTask.get();
                templates.add(tempDesc);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new HandleException((Throwable)e, "\u5728\u6267\u884c\u591a\u4efb\u52a1\u65f6\u51fa\u9519", new Object[0]);
            }
        }
        return resp;
    }

    @PostMapping(value={"/cgi-bin/wxopen/template/del?access_token=%s"})
    public void deleteSiteMessageTemplate(String var1, String var2);

    @PostMapping(value={"/cgi-bin/wxopen/template/library/get?access_token=%s"})
    public MessageTemplateResponse getWeixinMessageTemplate(String var1, String var2);

    @PostMapping(value={"/cgi-bin/wxopen/template/add?access_token=%s"})
    public String createSiteMessageTemplate(String var1, String var2, int[] var3);

    @PostMapping(value={"/cgi-bin/wxopen/template/list?access_token=%s"})
    public SiteMessageTemplatesResponse getSiteTemplates(String var1);

    @PostMapping(value={"/cgi-bin/message/wxopen/template/send?access_token=%s"})
    public SiteMessageTemplatesResponse sendTemplateMessage(String var1, String var2, String var3, String var4, String var5, String[] var6, String[] var7);

    @PostMapping(value={"/cgi-bin/message/custom/send?access_token=%s"})
    public SimpleResponse sendCustomMessageText(String var1, String var2, String var3);

    @PostMapping(value={"/cgi-bin/message/custom/send?access_token=%s"})
    public SimpleResponse sendCustomMessageMapp(String var1, String var2, String var3, String var4, String var5);

    @PostMapping(value={"/cgi-bin/message/custom/send?access_token=%s"})
    public SimpleResponse sendCustomMessagePhotoText(String var1, String var2, String var3, String var4, String var5, String var6);

    @PostMapping(value={"/cgi-bin/message/custom/send?access_token=%s"})
    public SimpleResponse sendCustomMessagePhoto(String var1, String var2, String var3);

    @PostMapping(value={"/cgi-bin/message/subscribe/send?access_token=%s"})
    public SimpleResponse sendSubscribeMessage(String var1, String var2, String var3, List<SubscribeMessageParam> var4);
}

