/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.mapp.model;

import com.google.gson.annotations.SerializedName;
import com.mini.framework.third.weixin.mapp.model.state.MappCodePhotoUseEnv;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.params.MapParams;
import com.mini.framework.util.string.GsonUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MappCodePhotoRequest {
    private static final Logger logger = LogManager.getLogger(MappCodePhotoRequest.class);
    @SerializedName(value="scene")
    private String scene;
    @SerializedName(value="page")
    private String page;
    @SerializedName(value="width")
    private Integer size;
    @SerializedName(value="auto_color")
    private Boolean authColor;
    @SerializedName(value="line_color")
    private Map<String, Integer> lineColor;
    @SerializedName(value="is_hyaline")
    private Boolean hyaline;
    @SerializedName(value="check_path")
    private Boolean strictPath = false;
    @SerializedName(value="env_version")
    private MappCodePhotoUseEnv useEnv;

    public void fillUseEnvRelease() {
        this.useEnv = MappCodePhotoUseEnv.release;
    }

    public void fillUseEnvTrial() {
        this.useEnv = MappCodePhotoUseEnv.trial;
    }

    public void fillUseEnvDevelop() {
        this.useEnv = MappCodePhotoUseEnv.develop;
    }

    public String getScene() {
        return this.scene;
    }

    public void setScene(String scene) {
        AssertUtil.assertSupport((scene == null || scene.length() <= 32 ? 1 : 0) != 0, (String)"\u573a\u666f\u7801\u4e0d\u80fd\u5927\u4e8e32\u4f4d", (Object[])new Object[]{scene});
        this.scene = scene;
    }

    public String getPage() {
        return this.page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public Boolean getAuthColor() {
        return this.authColor;
    }

    public void setAuthColor(Boolean authColor) {
        this.authColor = authColor;
    }

    public Map<String, Integer> getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Map<String, Integer> lineColor) {
        this.lineColor = lineColor;
    }

    public void setLineColor(int red, int green, int blue) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("r", red);
        map.put("g", green);
        map.put("b", blue);
        this.lineColor = map;
    }

    public Boolean getHyaline() {
        return this.hyaline;
    }

    public void setHyaline(Boolean hyaline) {
        this.hyaline = hyaline;
    }

    public Boolean getStrictPath() {
        return this.strictPath;
    }

    public void setStrictPath(Boolean strictPath) {
        this.strictPath = strictPath;
    }

    public MappCodePhotoUseEnv getUseEnv() {
        return this.useEnv;
    }

    public void setUseEnv(MappCodePhotoUseEnv useEnv) {
        this.useEnv = useEnv;
    }

    public String toJson() {
        String json = GsonUtil.buildMilliSecondDateGson().toJson((Object)this);
        return json;
    }

    public static MappCodePhotoRequest createSimpleCommandAwake(MapParams params, Function<String, String> hitLengthDeposit) {
        MappCodePhotoRequest request = new MappCodePhotoRequest();
        request.setPage("pages/command/awake");
        request.setHyaline(false);
        request.setAuthColor(false);
        request.setLineColor(0, 0, 0);
        String scene = params.toUrlParams();
        if (scene.length() > 32) {
            logger.debug("scene:[{}]\u5927\u4e8e32\u4f4d\u8d70commandDeposit\u5bc4\u5b58\u5230\u6570\u636e\u5e93", (Object)scene);
            String key = hitLengthDeposit.apply(scene);
            params = MapParams.build((String)"commandDeposit", (Object)key);
            scene = params.toUrlParams();
        }
        request.setScene(scene);
        return request;
    }
}

