/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.mapp.util;

import com.google.gson.Gson;
import com.mini.framework.core.status.Status;
import com.mini.framework.core.status.StatusCode;
import com.mini.framework.third.weixin.mapp.model.MappPhoneResponse;
import com.mini.framework.third.weixin.mapp.model.MappUserInfoResponse;
import com.mini.framework.third.weixin.mapp.model.MappUserInfoSecretResponse;
import com.mini.framework.third.weixin.util.WeixinAesCryptUtil;
import com.mini.framework.util.asserts.AssertUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MappCryptUtil {
    private static Logger logger = LogManager.getLogger(MappCryptUtil.class);

    public static MappPhoneResponse decryptPhoneData(String encryptedData, String iv, String sessionKey) {
        String result = WeixinAesCryptUtil.decryptData(encryptedData, iv, sessionKey);
        return (MappPhoneResponse)new Gson().fromJson(result, MappPhoneResponse.class);
    }

    public static void decryptUserInfo(MappUserInfoSecretResponse userInfoCrypt, String sessionKey) {
        String result = WeixinAesCryptUtil.decryptData(userInfoCrypt.getEncryptedData(), userInfoCrypt.getSecretSession(), sessionKey);
        AssertUtil.assertNotFatal((result != null ? 1 : 0) != 0, (StatusCode)Status.Busy.bug, (String)"\u89e3\u5bc6\u7ed3\u679c\u4e0d\u5e94\u8be5\u4e3a\u7a7auserInfoCrypt:[%s],sessionKey:[%s]", (Object[])new Object[]{userInfoCrypt, sessionKey});
        MappUserInfoResponse userInfo = (MappUserInfoResponse)new Gson().fromJson(result, MappUserInfoResponse.class);
        userInfo.setCrypt(true);
        userInfoCrypt.setCryptUserInfo(userInfo);
    }
}

