/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.notice.server.handler;

import com.mini.framework.core.exception.HandleStringException;
import com.mini.framework.core.exception.standard.CustomException;
import com.mini.framework.third.weixin.notice.server.handler.WeixinServerNoticeHandler;
import com.mini.framework.third.weixin.notice.server.model.WeixinNoticeType;
import com.mini.framework.third.weixin.notice.server.model.WeixinOpenidSureResult;
import com.mini.framework.third.weixin.notice.server.model.resp.EventClickNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.EventScanCodeNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.EventScanSubNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.EventSubscribeNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.EventTemplateResultNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.EventUnSubscribeNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.EventViewNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.EventWeixinAwakeSessionNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.FileNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.LocationNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.TextNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.VoiceNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.WeixinAskMsg;
import com.mini.framework.third.weixin.notice.server.model.resp.WeixinNotice;
import com.mini.framework.util.log.Event5WBuilder;
import com.mini.framework.util.log.MiniLogLevel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractWeixinServerNoticeHandler
implements WeixinServerNoticeHandler {
    private Logger logger = LogManager.getLogger(AbstractWeixinServerNoticeHandler.class);

    @Override
    public WeixinAskMsg handle(WeixinNotice weixinNotice) {
        this.logger.info("\u6536\u5230\u5fae\u4fe1\u901a\u77e5:{}", (Object)weixinNotice);
        this.logger.debug("\u6536\u5230\u5fae\u4fe1\u901a\u77e5:{}", (Object)weixinNotice);
        WeixinAskMsg weixinAskMsg = new WeixinAskMsg(weixinNotice, WeixinNoticeType.text.getType());
        try {
            weixinAskMsg.setNoneContent();
            WeixinNoticeType type = weixinNotice.getWeixinNoticeType();
            this.dispatcher(type, weixinNotice, weixinAskMsg);
        }
        catch (HandleStringException e) {
            this.logger.log(MiniLogLevel.getKeyBizLog(), "\u53d1\u73b0\u4e00\u4e2aweixin notice\u5f02\u5e38:{}", (Object)e.getMessage());
            weixinAskMsg.setContent("\u6570\u636e\u5904\u7406\u5f02\u5e38");
            this.logger.error("\u5904\u7406\u5fae\u4fe1\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
        catch (CustomException e) {
            this.logger.log(MiniLogLevel.getKeyBizLog(), "\u53d1\u73b0\u4e00\u4e2aweixin notice\u5f02\u5e38:{}", (Object)e.getMessage());
            this.logger.error("\u5904\u7406\u5fae\u4fe1\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            weixinAskMsg.setContent(e.getMessage());
        }
        catch (RuntimeException e) {
            this.logger.log(MiniLogLevel.getKeyBizLog(), "\u53d1\u73b0\u4e00\u4e2aweixin notice\u672a\u77e5\u5f02\u5e38,\u5177\u4f53\u89c1\u540e\u9762\u7684\u65e5\u5fd7");
            this.logger.error("\u5904\u7406\u5fae\u4fe1\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            weixinAskMsg.setContent("\u7cfb\u7edf\u7e41\u5fd9...");
        }
        return weixinAskMsg;
    }

    private void dispatcher(WeixinNoticeType type, WeixinNotice weixinNotice, WeixinAskMsg weixinAskMsg) {
        this.logger.debug("\u6536\u5230 weixinNotice:{}", (Object)weixinNotice);
        switch (type) {
            case file: {
                this.handleFile((FileNotice)weixinNotice, weixinAskMsg);
                break;
            }
            case text: {
                this.handleText((TextNotice)weixinNotice, weixinAskMsg);
                break;
            }
            case voice: {
                this.handleVoice((VoiceNotice)weixinNotice, weixinAskMsg);
                break;
            }
            case location: {
                this.handleLocation((LocationNotice)weixinNotice, weixinAskMsg);
                break;
            }
            case eventScancodeWaitmsg: {
                this.handleEvent((EventScanCodeNotice)weixinNotice, weixinAskMsg);
                break;
            }
            case eventView: {
                this.handleEvent((EventViewNotice)weixinNotice, weixinAskMsg);
                break;
            }
            case eventSubscribe: {
                this.handleEvent((EventSubscribeNotice)weixinNotice, weixinAskMsg);
                break;
            }
            case eventUnsubscribe: {
                this.handleEvent((EventUnSubscribeNotice)weixinNotice, weixinAskMsg);
                break;
            }
            case eventScan: {
                this.handleEvent((EventScanSubNotice)weixinNotice, weixinAskMsg);
                break;
            }
            case eventTemplateResult: {
                this.handleEvent((EventTemplateResultNotice)weixinNotice, weixinAskMsg);
                break;
            }
            case eventMappAwake: {
                this.handleEvent((EventWeixinAwakeSessionNotice)weixinNotice, weixinAskMsg);
                break;
            }
            case eventClick: {
                this.handleEvent((EventClickNotice)weixinNotice, weixinAskMsg);
                break;
            }
            default: {
                this.logger.info("\u6536\u5230\u5fae\u4fe1\u4e8b\u4ef6\u8fd8\u6ca1\u6709\u5b9a\u4e49\u5904\u7406\u7684\u529e\u6cd5,\u4e8b\u4ef6:{}", (Object)weixinNotice);
                weixinAskMsg.setContent(String.format("\u6536\u5230%s\u6d88\u606f", weixinNotice.getType()));
            }
        }
        this.logger.debug("\u54cd\u5e94 weixinAskMsg:{}", (Object)weixinAskMsg);
    }

    protected void handleEvent(EventClickNotice weixinNotice, WeixinAskMsg weixinAskMsg) {
        weixinAskMsg.setContent("\u70b9\u51fb\u4e86key:%s", weixinNotice.showButtonFlagKey());
    }

    protected void handleEvent(EventWeixinAwakeSessionNotice weixinNotice, WeixinAskMsg weixinAskMsg) {
        weixinAskMsg.setContent("\u77e5\u9053\u4f60\u6253\u5f00\u4f1a\u8bdd\u4e86sessionParam:" + weixinNotice.getSessionParam());
    }

    protected abstract void handleEvent(EventTemplateResultNotice var1, WeixinAskMsg var2);

    protected void handleEvent(EventScanSubNotice weixinNotice, WeixinAskMsg weixinAskMsg) {
        String sceneCode = weixinNotice.getEventKey();
        WeixinOpenidSureResult sureUser = weixinNotice.getOpenidUser();
        this.handleSubscribe(weixinNotice.getOpenidUser());
        Event5WBuilder event = Event5WBuilder.event((int)2, (Object)"inviteSubWeixin").who("\u7528\u6237:[%s]", new Object[]{sureUser.getUserId()}).what("\u626b\u7801(\u5e26code:[%s])\u5173\u6ce8\u4e86:[%s]", new Object[]{sceneCode, weixinNotice.getServAcc()}).when("\u975e\u9996\u6b21\u5173\u6ce8", new Object[0]);
        this.logger.debug((Object)event);
        this.handleSceneInvite(weixinNotice.getWeixinNoticeType(), weixinNotice.getOpenidUser(), sceneCode);
    }

    protected void handleLocation(LocationNotice weixinNotice, WeixinAskMsg weixinAskMsg) {
        this.logger.info("\u7528\u6237\u53d1\u9001\u4e00\u4e2a\u5730\u5740:{}", (Object)weixinNotice);
        weixinAskMsg.setContent("\u539f\u6765\u4f60\u5728 %s ,\u6211\u9a6c\u4e0a\u98de\u8fc7\u6765", weixinNotice.getLabel());
    }

    protected void handleFile(FileNotice weixinNotice, WeixinAskMsg weixinAskMsg) {
        this.logger.info("\u7528\u6237\u4e0a\u4f20\u4e86\u4e00\u4e2a\u6587\u4ef6:{}", (Object)weixinNotice);
        weixinAskMsg.setContent(String.format("\u6536\u5230\u6587\u4ef6:%s,%s", weixinNotice.getTitle(), weixinNotice.getDesc()));
    }

    protected abstract void handleEvent(EventUnSubscribeNotice var1, WeixinAskMsg var2);

    protected void handleEvent(EventSubscribeNotice weixinNotice, WeixinAskMsg weixinAskMsg) {
        weixinAskMsg.setContent("\u611f\u8c22\u4f60\u7684\u5173\u6ce8");
        WeixinOpenidSureResult sureUser = weixinNotice.getOpenidUser();
        this.handleSubscribe(sureUser);
        String sceneCode = weixinNotice.showRightInviteCode();
        if (sceneCode != null) {
            Event5WBuilder event = Event5WBuilder.event((int)2, (Object)"inviteSubWeixin").who("\u7528\u6237:[%s]", new Object[]{sureUser.getUserId()}).what("\u626b\u7801(\u5e26code:[%s])\u5173\u6ce8\u4e86:[%s]", new Object[]{sceneCode, weixinNotice.getServAcc()}).when("\u9996\u6b21\u5173\u6ce8", new Object[0]);
            this.logger.debug((Object)event);
            this.handleSceneInvite(weixinNotice.getWeixinNoticeType(), sureUser, sceneCode);
        }
    }

    protected void handleEvent(EventViewNotice eventNotice, WeixinAskMsg weixinAskMsg) {
        String url = eventNotice.getViewUrl();
        this.logger.info("\u7528\u6237\u4f7f\u7528\u6309\u94ae:{}\u6253\u5f00\u4e86url:{}", (Object)eventNotice.getMenuId(), (Object)url);
    }

    protected void handleEvent(EventScanCodeNotice weixinNotice, WeixinAskMsg weixinAskMsg) {
        weixinAskMsg.setContent("\u4f60\u5e72\u561b\u62ff\u6211\u626b\uff01");
        weixinNotice.getScanInfo().getType();
    }

    protected void handleText(TextNotice textNotice, WeixinAskMsg weixinAskMsg) {
        weixinAskMsg.setContent("\u5df2\u6536\u5230\u4e00\u4e2a\u6587\u672c\u6d88\u606f:" + textNotice.getContent());
    }

    protected void handleVoice(VoiceNotice voiceNotice, WeixinAskMsg weixinAskMsg) {
        weixinAskMsg.setContent(String.format("\u6211\u542c\u5230\u7684\u662f:[%s]", voiceNotice.getTranText()));
    }

    protected abstract void handleSceneInvite(WeixinNoticeType var1, WeixinOpenidSureResult var2, String var3);

    protected abstract void handleSubscribe(WeixinOpenidSureResult var1);
}

